package com.intellij.psi.css.descriptor.value;

import org.jetbrains.annotations.Nullable;

public enum CssValueType {
  GROUP, INLINE, COLOR, URI, STRING, INTEGER, NUMBER, PERCENTAGE, NAME, PROPERTY,
  ANGLE, FREQUENCY, POSITION, RESOLUTION, TIME, URANGE,
  LENGTH, INVOKE, TEXT, EXPRESSION, JAVASCRIPT, SELECTOR, ANY, DECIBEL, SEMITONES;

  @Nullable
  public static CssValueType fromTag(@Nullable String tagName) {
    for (CssValueType type : values()) {
      if (type.name().equalsIgnoreCase(tagName)) {
        return type;
      }
    }
    return null;
  }
}
