/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.imp;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.projectImport.SelectImportedProjectsStep;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.imp.BndProjectImportBuilder;
import org.jetbrains.osgi.bnd.imp.BndProjectImporter;
import org.osmorc.i18n.OsmorcBundle;

class BndSelectProjectsStep
extends SelectImportedProjectsStep<Project> {
    public BndSelectProjectsStep(WizardContext context) {
        super(context);
    }

    public String getHelpId() {
        return "Import from Bnd_Bndtools Page 1";
    }

    public void updateStep() {
        this.initWorkspace();
        super.updateStep();
    }

    private void initWorkspace() {
        final BndProjectImportBuilder builder = (BndProjectImportBuilder)this.getContext();
        Workspace workspace = builder.getWorkspace();
        if (workspace != null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(null, OsmorcBundle.message("bnd.import.progress.enumerating", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/imp/BndSelectProjectsStep$1", "run"));
                }
                try {
                    String directory = BndSelectProjectsStep.this.getWizardContext().getProjectFileDirectory();
                    Workspace workspace = Workspace.getWorkspace((File)new File(directory), (String)"cnf");
                    builder.setWorkspace(workspace, BndProjectImporter.getWorkspaceProjects(workspace));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected String getElementText(Project project) {
        return project.getName() + " (" + project.getBase() + ")";
    }
}

