/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.persistent;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.jboss.arquillian.configuration.ArquillianContainersAppManager;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianListState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ConfigurationSpecificState;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Tag(value="container")
public class ArquillianContainerState
implements ArquillianListState<ArquillianLibraryState>,
Comparable<ArquillianContainerState> {
    @Attribute(value="containerId")
    @NotNull
    public String containerId;
    @Attribute(value="name")
    @NotNull
    public String name;
    @Attribute(value="jvmParameters")
    @NotNull
    public String jvmParameters;
    @AbstractCollection(surroundWithTag=false, elementTypes={ArquillianMavenLibraryState.class, ArquillianExistLibraryState.class})
    @Property(surroundWithTag=false)
    @NotNull
    public List<ArquillianLibraryState> libraries;
    @AbstractCollection(surroundWithTag=false)
    @Property
    @Tag(value="env-variables")
    @NotNull
    public Map<String, String> envVariables;
    @Property(surroundWithTag=false)
    @Tag(value="configurationSpecific")
    @NotNull
    public ConfigurationSpecificState configurationSpecificState;

    public ArquillianContainerState() {
        this("", "", new ArrayList<ArquillianLibraryState>());
    }

    public ArquillianContainerState(@NotNull String containerId, @NotNull String name, @NotNull List<ArquillianLibraryState> libraries) {
        if (containerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        this(containerId, name, libraries, "", new HashMap<String, String>(), new ConfigurationSpecificState());
    }

    public ArquillianContainerState(@NotNull String containerId, @NotNull String name, @NotNull List<ArquillianLibraryState> libraries, @NotNull String jvmParameters, @NotNull Map<String, String> envVariables, @NotNull ConfigurationSpecificState configurationSpecificState) {
        if (containerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (jvmParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmParameters", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (envVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariables", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        if (configurationSpecificState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationSpecificState", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "<init>"));
        }
        this.configurationSpecificState = new ConfigurationSpecificState();
        this.containerId = containerId;
        this.name = name;
        this.libraries = libraries;
        this.jvmParameters = jvmParameters;
        this.envVariables = envVariables;
        this.configurationSpecificState = configurationSpecificState;
    }

    @NotNull
    public String getContainerId() {
        String string = this.containerId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getContainerId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getName"));
        }
        return string;
    }

    @NotNull
    public String getJvmParameters() {
        String string = this.jvmParameters;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getJvmParameters"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map = this.envVariables;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getEnvVariables"));
        }
        return map;
    }

    @NotNull
    public List<ArquillianLibraryState> getLibraries() {
        List<ArquillianLibraryState> list = this.libraries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getLibraries"));
        }
        return list;
    }

    public void setLibraries(@NotNull List<ArquillianLibraryState> libraries) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "setLibraries"));
        }
        this.libraries = libraries;
    }

    @NotNull
    public ConfigurationSpecificState getRemoteDebuggerState() {
        ConfigurationSpecificState configurationSpecificState = this.configurationSpecificState;
        if (configurationSpecificState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainerState", "getRemoteDebuggerState"));
        }
        return configurationSpecificState;
    }

    public ArquillianContainerState clone() {
        ArquillianContainerState result = new ArquillianContainerState();
        XmlSerializerUtil.copyBean((Object)this, (Object)result);
        return result;
    }

    @Override
    public int compareTo(ArquillianContainerState other) {
        int otherWeight;
        int weight;
        ArquillianContainer container = ArquillianContainersAppManager.getInstance().findContainerById(this.containerId);
        ArquillianContainer otherContainer = ArquillianContainersAppManager.getInstance().findContainerById(other.containerId);
        if (container != null && otherContainer != null && !container.equals(otherContainer) && (weight = container.getScope().getWeight()) != (otherWeight = otherContainer.getScope().getWeight())) {
            return weight < otherWeight ? -1 : 1;
        }
        return StringUtil.compare((String)this.getName(), (String)other.getName(), (boolean)true);
    }

    @Override
    public List<ArquillianLibraryState> getChildren() {
        return this.libraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArquillianContainerState state = (ArquillianContainerState)o;
        if (!this.containerId.equals(state.containerId)) {
            return false;
        }
        if (!this.name.equals(state.name)) {
            return false;
        }
        if (!this.jvmParameters.equals(state.jvmParameters)) {
            return false;
        }
        if (!this.libraries.equals(state.libraries)) {
            return false;
        }
        if (!this.envVariables.equals(state.envVariables)) {
            return false;
        }
        return this.configurationSpecificState.equals(state.configurationSpecificState);
    }

    public int hashCode() {
        int result = this.containerId.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.jvmParameters.hashCode();
        result = 31 * result + this.libraries.hashCode();
        result = 31 * result + this.envVariables.hashCode();
        result = 31 * result + this.configurationSpecificState.hashCode();
        return result;
    }
}

