/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.inspection.ArquillianDeploymentCountInspectionBase;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArquillianTooManyDeploymentInspection
extends ArquillianDeploymentCountInspectionBase {
    @Override
    protected void checkDeploymentMethods(@NotNull PsiClass aClass, @NotNull List<PsiMethod> deploymentMethods, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianTooManyDeploymentInspection", "checkDeploymentMethods"));
        }
        if (deploymentMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentMethods", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianTooManyDeploymentInspection", "checkDeploymentMethods"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianTooManyDeploymentInspection", "checkDeploymentMethods"));
        }
        for (PsiMethod method : deploymentMethods) {
            if (!method.getContainingFile().equals(aClass.getContainingFile())) continue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.jboss.arquillian.container.test.api.Deployment"});
            holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)(annotation != null ? annotation : (method.getNameIdentifier() != null ? method.getNameIdentifier() : method)), ArquillianBundle.message("arquillian.deployment.too.many", new Object[0]), holder.isOnTheFly(), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    @Override
    protected boolean wouldLikeToCheckMethodCount(int count) {
        return count > 1;
    }
}

