/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionGraph {
    private static final Function<Object, Object> IDENTITY = o -> o;
    private static final ConversionGraph INSTANCE = new ConversionGraph();
    private final MultiMap<PointSet, Node> myMap = new MultiMap<PointSet, Node>(){

        @NotNull
        protected Collection<Node> createCollection() {
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConversionGraph$1", "createCollection"));
            }
            return linkedHashSet;
        }
    };

    ConversionGraph() {
    }

    @Nullable
    private List<Node> shortestPath(@NotNull PointSet from, @NotNull PointSet to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/data/types/ConversionGraph", "shortestPath"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/data/types/ConversionGraph", "shortestPath"));
        }
        JBTreeTraverser traverser = new JBTreeTraverser(node -> this.myMap.get((Object)((Node)node).pointSet));
        TreeTraversal.TracingIt iterator = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser.withRoots((Iterable)this.myMap.get((Object)from))).tracingBfsTraversal().unique(node -> ((Node)node).pointSet).typedIterator();
        Ref parent = Ref.create((Object)from);
        HashMap path = ContainerUtil.newHashMap();
        iterator.forEachRemaining(node -> {
            Node itParent = (Node)iterator.parent();
            if (itParent != null && itParent.pointSet != parent.get()) {
                parent.set((Object)itParent.pointSet);
            }
            path.put(((Node)node).pointSet, parent.get());
        });
        return path.containsKey(to) && path.containsKey(from) ? this.flat(path, from, to) : null;
    }

    @NotNull
    private List<Node> flat(@NotNull Map<PointSet, PointSet> path, @NotNull PointSet start, @NotNull PointSet end) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/data/types/ConversionGraph", "flat"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/data/types/ConversionGraph", "flat"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/database/data/types/ConversionGraph", "flat"));
        }
        ArrayList nodes2 = ContainerUtil.newArrayList();
        while (path.get(end) != null) {
            PointSet previous = path.get(end);
            PointSet current = end;
            Node node = (Node)ContainerUtil.find((Iterable)this.myMap.get((Object)previous), currentNode -> Comparing.equal((Object)((Node)currentNode).pointSet, (Object)current));
            if (node == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConversionGraph", "flat"));
                }
                return list;
            }
            nodes2.add(node);
            if ((end = path.get(end)) != start) continue;
            break;
        }
        List list = ContainerUtil.reverse((List)nodes2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConversionGraph", "flat"));
        }
        return list;
    }

    @Nullable
    public static Function<Object, Object> getConverter(@Nullable Object o, @NotNull Domain from, @NotNull Domain to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/data/types/ConversionGraph", "getConverter"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/data/types/ConversionGraph", "getConverter"));
        }
        DataConverter.init();
        ConversionPoint<?> startPoint = o == null ? from.getPoint() : from.getPoint().withClass(o.getClass());
        ConversionPoint endPoint = to.getPoint();
        PointSet start = PointSet.of(startPoint);
        PointSet end = PointSet.of(endPoint);
        List<Node> nodes2 = INSTANCE.shortestPath(start, end);
        if (nodes2 == null) {
            return null;
        }
        List functions = ContainerUtil.map(nodes2, node -> ((Node)node).function);
        Function resultFunction = null;
        for (Function function : functions) {
            if (resultFunction == null) {
                resultFunction = function;
                continue;
            }
            resultFunction = Functions.compose((Function)resultFunction, (Function)function);
        }
        resultFunction = resultFunction == null ? null : Functions.compose(resultFunction, obj -> {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/data/types/ConversionGraph", "lambda$getConverter$6"));
            }
            return obj == null ? null : to.trim(obj);
        });
        return resultFunction == null ? null : resultFunction;
    }

    public static void register(@NotNull DataConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/data/types/ConversionGraph", "register"));
        }
        PointSet start = converter.getStart();
        PointSet end = converter.getEnd();
        ConversionGraph.INSTANCE.myMap.putValue(start, (Object)new Node(end, converter::convert));
        ConversionGraph.INSTANCE.myMap.putValue(end, (Object)new Node(start, converter::convertReverse));
        ConversionGraph.INSTANCE.myMap.putValue(start, (Object)new Node(start, IDENTITY));
        ConversionGraph.INSTANCE.myMap.putValue(end, (Object)new Node(end, IDENTITY));
    }

    private static class Node {
        private final PointSet pointSet;
        private final Function<Object, Object> function;

        private Node(@NotNull PointSet pointSet, @Nullable Function<Object, Object> function) {
            if (pointSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointSet", "com/intellij/database/data/types/ConversionGraph$Node", "<init>"));
            }
            this.pointSet = pointSet;
            this.function = function;
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && this.pointSet.equals(((Node)obj).pointSet) && this.function == ((Node)obj).function;
        }

        public int hashCode() {
            return this.pointSet.hashCode() + Objects.hashCode(this.function);
        }

        public String toString() {
            return this.pointSet.toString();
        }
    }
}

