/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class Float1Domain
extends FloatDomain {
    private final DomainRegistry.Limit[] myLimits;

    public Float1Domain(@NotNull String name, @NotNull ConversionPoint descriptor, DomainRegistry.Limit ... limits) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (limits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        super(name, descriptor, Float1Domain.min(limits), Float1Domain.max(limits));
        this.myLimits = limits;
    }

    /*
     * WARNING - void declaration
     */
    public Float1Domain(@NotNull String name, @NotNull ConversionPoint descriptor, double min, double max, DomainRegistry.Limit ... limitArray) {
        void limits;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (limitArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        super(name, descriptor, min, max);
        this.myLimits = limits;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        if (!(domain instanceof NumberDomain)) {
            Float1Domain float1Domain = this;
            if (float1Domain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
            }
            return float1Domain;
        }
        Domain domain2 = this.singleParameter((NumberDomain)domain);
        if (domain2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        return domain2;
    }

    @NotNull
    private Domain singleParameter(@NotNull NumberDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Float1Domain", "singleParameter"));
        }
        Float1Domain float1Domain = new Float1Domain(this.simpleName(), this.getPoint(), domain.getMinValue(), domain.getMaxValue(), this.myLimits);
        if (float1Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "singleParameter"));
        }
        return float1Domain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        int size = provider.getSize();
        for (DomainRegistry.Limit limit : this.myLimits) {
            if (size <= limit.getMaxParameter().intValue()) continue;
            Float1Domain float1Domain = new Float1Domain(this.simpleName(), this.getPoint(), limit.getMinValue().doubleValue(), limit.getMaxValue().doubleValue(), this.myLimits);
            if (float1Domain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
            }
            return float1Domain;
        }
        Float1Domain float1Domain = this;
        if (float1Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        return float1Domain;
    }

    @Override
    @NotNull
    public String name() {
        String string = super.name() + "(" + this.findParameter() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "name"));
        }
        return string;
    }

    private byte findParameter() {
        for (DomainRegistry.Limit limit : this.myLimits) {
            if (!((double)limit.getMaxValue().intValue() > this.getMaxValue())) continue;
            return limit.getMaxParameter().byteValue();
        }
        return ((DomainRegistry.Limit)ObjectUtils.assertNotNull((Object)ArrayUtil.getLastElement((Object[])this.myLimits))).getMaxParameter().byteValue();
    }

    private static double max(DomainRegistry.Limit ... limits) {
        if (limits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "max"));
        }
        double max = Double.MIN_VALUE;
        for (DomainRegistry.Limit limit : limits) {
            if (Double.compare(limit.getMaxValue().doubleValue(), max) <= 0) continue;
            max = limit.getMaxValue().doubleValue();
        }
        return max;
    }

    private static double min(DomainRegistry.Limit ... limits) {
        if (limits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "min"));
        }
        double min = Double.MAX_VALUE;
        for (DomainRegistry.Limit limit : limits) {
            if (Double.compare(limit.getMinValue().doubleValue(), min) >= 0) continue;
            min = limit.getMinValue().doubleValue();
        }
        return min;
    }
}

