/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.NumberDomain;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerDomain
extends NumberDomain {
    private final Cardinality.MinMaxCardinality myCardinality;

    /*
     * WARNING - void declaration
     */
    public IntegerDomain(@NotNull String name, @NotNull ConversionPoint descriptor, double minValue, double d) {
        void maxValue;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/IntegerDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/IntegerDomain", "<init>"));
        }
        super(name, descriptor, minValue, (double)maxValue);
        this.myCardinality = new Cardinality.MinMaxCardinality(minValue, (double)maxValue, false);
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.MinMaxCardinality minMaxCardinality = this.myCardinality;
        if (minMaxCardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IntegerDomain", "cardinality"));
        }
        return minMaxCardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/IntegerDomain", "getCompatibility"));
        }
        Compatibility compatibility = domain instanceof IntegerDomain ? (((IntegerDomain)domain).getMinValue() >= this.getMinValue() && ((IntegerDomain)domain).getMaxValue() <= this.getMaxValue() ? Compatibility.full(this.cardinality(), this.getLogicType(), domain.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), this.getLogicType(), domain.getLogicType())) : (domain instanceof Number2Domain ? (((Number2Domain)domain).getMaxScale() == 0 && this.containsFully((Number2Domain)domain) ? Compatibility.full(this.cardinality(), this.getLogicType(), domain.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), this.getLogicType(), domain.getLogicType())) : (domain instanceof FloatDomain ? Compatibility.compatibleLossy(this.cardinality(), this.getLogicType(), domain.getLogicType()) : (domain instanceof BooleanDomain ? Compatibility.uncompatibleLossless(this.cardinality(), this.getLogicType(), domain.getLogicType()) : Compatibility.uncompatible())));
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IntegerDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/IntegerDomain", "trim"));
        }
        return o instanceof Number ? this.trim((Number)o) : o;
    }

    @NotNull
    private Number trim(@NotNull Number n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/database/data/types/domain/IntegerDomain", "trim"));
        }
        Number number = n instanceof BigInteger ? this.trim((BigInteger)n) : (n.longValue() > (long)this.getMaxValue() ? (Number)((long)this.getMaxValue()) : (Number)(n.longValue() < (long)this.getMinValue() ? (Number)((long)this.getMinValue()) : (Number)(n instanceof Double || n instanceof Float || n instanceof BigDecimal ? (Number)n.longValue() : (Number)n)));
        if (number == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IntegerDomain", "trim"));
        }
        return number;
    }

    @NotNull
    private BigInteger trim(@NotNull BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bigInteger", "com/intellij/database/data/types/domain/IntegerDomain", "trim"));
        }
        BigInteger max = BigInteger.valueOf((long)this.getMaxValue());
        BigInteger min = BigInteger.valueOf((long)this.getMinValue());
        BigInteger bigInteger2 = max.compareTo(bigInteger) < 0 ? max : (min.compareTo(bigInteger) > 0 ? min : bigInteger);
        if (bigInteger2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/IntegerDomain", "trim"));
        }
        return bigInteger2;
    }

    private boolean containsFully(@NotNull Number2Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/IntegerDomain", "containsFully"));
        }
        int precision = domain.getMaxPrecision();
        int digits = (int)Math.log10(this.getMaxValue()) + 1;
        return digits >= precision;
    }
}

