/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelModernLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ObjectUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DatabaseModelLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performIntrospection(@NotNull ModelFactory modelFactory, @NotNull LoaderContext context, @NotNull DasModel model, @NotNull Connection connection, @NotNull DBIntrospectionOptions options, @NotNull ProgressIndicator progressIndicator) {
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new AssertionError((Object)"Introspection should not be run in EDT");
        }
        Rdbms rdbms = (Rdbms)ObjectUtils.chooseNotNull((Object)DataSourceUiUtil.getRdbmsForIntrospection(context.getFamilyId()), (Object)UnknownDatabase.RDBMS);
        boolean forceLegacy = DatabaseModelLoader.whetherForcedLegacy(context);
        PrimeIntermediateFacade remoteFacade = DatabaseModelLoader.getRemoteFacade(connection, rdbms);
        AdaptIntermediateFacade intermediateFacade = null;
        try {
            intermediateFacade = new AdaptIntermediateFacade(remoteFacade);
            BaseFacade facade = new BaseFacade((IntegralIntermediateFacade)intermediateFacade);
            try {
                facade.connect();
                DatabaseModelModernLoader.performModernIntrospection(modelFactory, (DBFacade)facade, context, model, progressIndicator, options, forceLegacy);
            }
            catch (Exception e) {
                context.getErrorHandler().addError(e.getMessage(), (Throwable)e);
            }
            finally {
                facade.disconnect();
            }
            DbSrcUtils.refresh();
        }
        finally {
            if (intermediateFacade != null) {
                intermediateFacade.disconnect();
            }
            remoteFacade.disconnect();
        }
    }

    @NotNull
    private static PrimeIntermediateFacade getRemoteFacade(@NotNull Connection connection, Rdbms rdbms) {
        PrimeIntermediateFacade remoteFacade;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "getRemoteFacade"));
        }
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemote((Object)connection, RemoteConnection.class);
        assert (remoteConnection != null);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            remoteFacade = (PrimeIntermediateFacade)RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            assert (remoteFacade != null);
            assert (remoteFacade.rdbms().code.equals(rdbms.code));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        PrimeIntermediateFacade primeIntermediateFacade = remoteFacade;
        if (primeIntermediateFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getRemoteFacade"));
        }
        return primeIntermediateFacade;
    }

    private static boolean whetherForcedLegacy(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "whetherForcedLegacy"));
        }
        LocalDataSource dataSource = context.getDataSource();
        return dataSource != null && dataSource.useLegacyIntrospector();
    }

    public static boolean isScopeInverted(@NotNull DatabaseFamilyId familyId) {
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/dataSource/DatabaseModelLoader", "isScopeInverted"));
        }
        return familyId.isMysql();
    }

    public static boolean schemaMatches(@NotNull DasObject schema, @NotNull IntrospectionScope scope, boolean inverted) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        DasObject parent = schema.getDbParent();
        String parentName = parent == null ? "*" : parent.getName();
        return inverted ? scope.containsSchema(schema.getName(), parentName) : scope.containsSchema(parentName, schema.getName());
    }
}

