/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator.Typed<DatabaseDriverImpl> {
    public DatabaseDriverValidator() {
        super(DatabaseDriverImpl.class);
    }

    @Override
    public void findProblemsTyped(@NotNull DatabaseDriverImpl baseDriver, @NotNull Consumer<DataSourceProblem> problems, @NotNull DatabaseConfigValidator.Control control) {
        if (baseDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDriver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        DatabaseDriverImpl driver = control.actualize(baseDriver, false);
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXml((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXml((String)((String)pair.getSecond())));
            }
            String shortDesc = msg.toString();
            String longDesc = "Driver <a href=\"$ACTION0\">" + StringUtil.escapeXml((String)driver.getFullName()) + "</a> has invalid templates:" + shortDesc;
            problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText("Invalid template", shortDesc, longDesc, new DataSourceProblem.Navigate(driver)), null));
        }
    }

    public static boolean isDriverFilesValid(@NotNull String artifact, @Nullable String version, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isDriverFilesValid"));
        }
        DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
        if (version == null) {
            return actual != null && !JBIterable.from(actual).flatten(e -> e.getClassesRootUrls()).isEmpty();
        }
        return manager.isValid(artifact, version);
    }

    public static boolean isDriverFilesUpToDate(@NotNull String artifact, @Nullable String version, boolean isRolling, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isDriverFilesUpToDate"));
        }
        DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
        String actualVersion = manager.getActualVersion(artifact);
        if (!isRolling && version != null || actualVersion == null || Comparing.equal((String)version, (String)actualVersion)) {
            return true;
        }
        if (version != null) {
            return false;
        }
        JBIterable urls = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (!urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty()) {
            return false;
        }
        return DatabaseArtifactManager.getInstance().isFreshFiles(artifact, actualVersion, urls.transform(VfsUtil::extractFileName).toSet());
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver baseDriver, @NotNull Consumer<DataSourceProblem> problems, @NotNull DatabaseConfigValidator.Control control) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (baseDriver == null) {
            return;
        }
        DatabaseDriver driver = control.actualize(baseDriver, false);
        DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
        if (artifact != null && artifact.isUsed()) {
            boolean needDownload;
            DatabaseArtifactManager.getInstance();
            String driverName = StringUtil.escapeXml((String)driver.getFullName());
            boolean bl = needDownload = !DatabaseDriverValidator.isDriverFilesValid(artifact.getName(), artifact.getVersion(), driver.getClasspathElements());
            if (needDownload) {
                NamedProgressive downloader = DatabaseDriverValidator.createDownloader(baseDriver, control, (String)ObjectUtils.chooseNotNull((Object)artifact.getVersion(), (Object)"latest"));
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", "<a href=\"$ACTION0\">Download</a> missing driver files", "Download missing <a href=\"$ACTION1\">" + driverName + "</a> driver files", downloader, new DataSourceProblem.Navigate(driver)), downloader));
            } else if (!DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), artifact.getVersion(), artifact.isRolling(), driver.getClasspathElements())) {
                NamedProgressive downloader = DatabaseDriverValidator.createDownloader(baseDriver, control, "latest");
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText("", "<a href=\"$ACTION0\">Update</a> driver files", "Update <a href=\"$ACTION1\">" + driverName + "</a> driver files", downloader, new DataSourceProblem.Navigate(driver)), downloader));
            }
        }
    }

    @NotNull
    private static NamedProgressive createDownloader(@NotNull DatabaseDriver baseDriver, @NotNull DatabaseConfigValidator.Control control, @NotNull String downloadVersion) {
        if (baseDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDriver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        if (downloadVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadVersion", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        NamedProgressive namedProgressive = NamedProgressive.named(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"}), indicator -> {
            if (control == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$createDownloader$3"));
            }
            if (baseDriver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDriver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$createDownloader$3"));
            }
            if (downloadVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadVersion", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$createDownloader$3"));
            }
            DatabaseDriver actual = control.actualize(baseDriver, true);
            DatabaseDriver.ArtifactRef artifact = actual.getArtifact();
            if (artifact == null) {
                return;
            }
            indicator.setText(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"}));
            while (!indicator.isCanceled()) {
                try {
                    String prevVer = artifact.getVersion();
                    String ver = DatabaseArtifactManager.getInstance().downloadArtifact(artifact.getName(), downloadVersion, (Consumer<String>)((Consumer)current -> {
                        if (control == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$null$2"));
                        }
                        if (!Comparing.equal((String)prevVer, (String)current)) {
                            control.changed(actual);
                        }
                    }));
                    if (ver == null) break;
                    ((DatabaseDriverImpl)actual).setArtifact(artifact.getName(), ver, artifact.isRolling());
                }
                catch (IOException e) {
                    String msg = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"});
                    boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                    if (retry) continue;
                }
                break;
            }
        });
        if (namedProgressive == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        return namedProgressive;
    }
}

