/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnUpdateData;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMutatorImpl
implements GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> {
    private final GridListModelBase<DataConsumer.Row, DataConsumer.Column> myModel;
    private final DatabaseGridDataHookUp myHookUp;
    private final Queue<ModelIndex<DataConsumer.Row>> myInsertedRows;
    private final Set<ModelIndex<DataConsumer.Row>> myDeletedRows;
    private final MutationsStorage myStorage;
    private boolean myFailed;

    public DatabaseMutatorImpl(@NotNull GridListModelBase<DataConsumer.Row, DataConsumer.Column> model, @NotNull DatabaseGridDataHookUp hookUp) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/DatabaseMutatorImpl", "<init>"));
        }
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/datagrid/DatabaseMutatorImpl", "<init>"));
        }
        this.myModel = model;
        this.myHookUp = hookUp;
        this.myInsertedRows = new PriorityQueue<ModelIndex<DataConsumer.Row>>((o1, o2) -> Integer.compare(o2.asInteger(), o1.asInteger()));
        this.myDeletedRows = ContainerUtil.newHashSet();
        this.myStorage = new MutationsStorage(model, 500, 10);
        this.myHookUp.addRequestListener(new MyRequestListener(), this.myHookUp);
    }

    @Override
    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "mutate"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "mutate"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseMutatorImpl", "mutate"));
        }
        this.mutate(source, DataGridUtil.createMutations(rows, columns, (Function<ModelIndex<DataConsumer.Row>, MutationType>)((Function)this::getMutationTypeWhenMutate), newValue));
    }

    @Override
    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull List<CellMutation> mutations) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "mutate"));
        }
        if (mutations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/datagrid/DatabaseMutatorImpl", "mutate"));
        }
        boolean hasInsertedRows = false;
        boolean hasNotInsertedRows = false;
        for (CellMutation mutation : mutations) {
            boolean shouldSkip;
            ModelIndex<DataConsumer.Column> columnIdx;
            Object value = mutation.getValue();
            ModelIndex<DataConsumer.Row> rowIdx = mutation.getRow();
            MutationData oldMutation = this.myStorage.get(rowIdx, columnIdx = mutation.getColumn());
            boolean bl = shouldSkip = oldMutation == null && this.myModel.allValuesEqualTo(ContainerUtil.list((Object[])new CellMutation[]{mutation})) || oldMutation != null && DbImplUtil.valuesEqual(oldMutation.getValue(), value);
            if (shouldSkip) continue;
            boolean isInserted = this.isInsertedRow(rowIdx);
            hasInsertedRows |= isInserted;
            hasNotInsertedRows |= !isInserted;
            CellMutation newValue = DbImplUtil.valuesEqual(mutation.getValue(), this.myModel.getValueAt((DataConsumer.Row)((Object)rowIdx), (DataConsumer.Column)((Object)columnIdx))) ? null : mutation;
            this.myStorage.set(rowIdx, columnIdx, newValue);
            this.myDeletedRows.remove(rowIdx);
            if (!isInserted) continue;
            this.myModel.setValueAt(rowIdx, columnIdx, value);
        }
        this.myFailed = false;
        if (this.isUpdateImmediately() && this.hasPendingChanges()) {
            this.submit(source, hasInsertedRows && hasNotInsertedRows && this.isUpdateImmediately());
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void revert(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "revert"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "revert"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseMutatorImpl", "revert"));
        }
        List<ModelIndex<DataConsumer.Row>> sorted = DatabaseMutatorImpl.sortedRows(rows);
        sorted.stream().filter(idx -> !this.isInsertedRow((ModelIndex<DataConsumer.Row>)idx) && !this.isDeletedRow((ModelIndex<DataConsumer.Row>)idx)).forEach(rowIdx -> {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseMutatorImpl", "lambda$revert$3"));
            }
            columns.asIterable().forEach(colIdx -> this.revert((ModelIndex<DataConsumer.Row>)rowIdx, (ModelIndex<DataConsumer.Column>)colIdx));
        });
        this.doDeleteRows(ModelIndexSet.forRows(this.myModel, sorted.stream().filter(this::isInsertedRow).mapToInt(Index::asInteger).toArray()));
        sorted.stream().filter(this::isDeletedRow).forEach(this.myDeletedRows::remove);
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    private void revert(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> colIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/DatabaseMutatorImpl", "revert"));
        }
        if (colIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colIdx", "com/intellij/database/datagrid/DatabaseMutatorImpl", "revert"));
        }
        this.myStorage.set(rowIdx, colIdx, null);
    }

    @Override
    public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DatabaseMutatorImpl", "isUpdateSafe"));
        }
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DatabaseMutatorImpl", "isUpdateSafe"));
        }
        if (!this.hasPendingChanges() || !this.isUpdateImmediately() || this.hasDifferentRowTypes(rowIndices)) {
            return true;
        }
        List<ModelIndex<DataConsumer.Row>> rows = this.getPhysicalRows(rowIndices);
        ModelIndex first = (ModelIndex)JBIterable.from(rows).filter(Condition.NOT_NULL).first();
        return first == null || this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue);
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "isInsertedRow"));
        }
        return this.myInsertedRows.contains(row);
    }

    @Override
    @Nullable
    public MutationData getMutation(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getMutation"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getMutation"));
        }
        return this.myStorage.get(row, column);
    }

    @Override
    public boolean isUpdateImmediately() {
        return DatabaseSettings.getSettings().isSubmitImmediately();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.myStorage.isModified() || !this.myInsertedRows.isEmpty() || !this.myDeletedRows.isEmpty();
    }

    @Override
    public void deleteRows(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "deleteRows"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "deleteRows"));
        }
        if (this.isReadOnly() || !this.doDeleteRows(rows)) {
            DatabaseMutatorImpl.setForceSuccess(source);
            this.notifyRequestFinished(source, !this.isReadOnly() && this.getDatabaseTable() != null);
            return;
        }
        if (this.isUpdateImmediately()) {
            this.submit(source, false);
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    @Override
    public void insertRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "insertRow"));
        }
        if (!this.isReadOnly()) {
            this.doInsertRow(this.createRow(null));
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void cloneRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "cloneRow"));
        }
        if (toClone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClone", "com/intellij/database/datagrid/DatabaseMutatorImpl", "cloneRow"));
        }
        DataConsumer.Row rowToClone = this.myModel.getRow(toClone);
        if (this.isReadOnly() || rowToClone == null) {
            this.notifyRequestFinished(source, false);
            return;
        }
        DataConsumer.Row newRow = this.createRow(rowToClone);
        this.doInsertRow(newRow);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public boolean isFailed() {
        return this.myFailed;
    }

    @NotNull
    protected DataConsumer.Row createRow(@Nullable DataConsumer.Row template) {
        DataConsumer.Row newRow = DataConsumer.Row.create(this.myHookUp.getPageModel().getPageEnd() + this.myInsertedRows.size(), new Object[this.myModel.getColumnCount()]);
        for (DataConsumer.Column column : this.myModel.getColumns()) {
            Object existing;
            DasColumn dbColumn = this.getDatabaseColumn(column);
            Object object = existing = template == null ? null : column.getValue(template);
            ReservedCellValue value = DbImplUtil.isComputedColumn(column) ? ReservedCellValue.GENERATED : (template != null && !DasUtil.isPrimary((DasColumn)dbColumn) ? existing : DataGridUtil.getDefaultNullValue(dbColumn));
            column.setValue(newRow, (Object)value);
        }
        DataConsumer.Row row = newRow;
        if (row == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createRow"));
        }
        return row;
    }

    @Override
    @Nullable
    public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
        return this.myInsertedRows.peek();
    }

    @Override
    public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "isDeletedRow"));
        }
        return this.myDeletedRows.contains(row);
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "isDeletedRows"));
        }
        return this.myDeletedRows.containsAll(rows.asList());
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getAffectedRows() {
        HashSet myRows = ContainerUtil.newHashSet();
        for (int row2 : this.myStorage.getAffectedRows()) {
            myRows.add(row2);
        }
        this.myDeletedRows.forEach(row -> myRows.add(row.asInteger()));
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myModel, myRows.stream().mapToInt(Integer::valueOf).toArray());
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getAffectedRows"));
        }
        return modelIndexSet;
    }

    @Override
    public void submit(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean inserted) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "submit"));
        }
        DasTable table = this.getDatabaseTable();
        if (this.isReadOnly() || table == null) {
            this.notifyRequestFinished(source, false);
            return;
        }
        if (this.myDeletedRows.isEmpty() && !this.myStorage.isModified() && (this.myInsertedRows.isEmpty() || !inserted)) {
            this.notifyUpdateCountReceived(source, this.myInsertedRows.size());
            this.notifyRequestFinished(source, true);
            return;
        }
        List<RowMutation> updateMutations = this.createUpdateMutations();
        List<RowMutation> insertMutations = inserted ? this.createInsertMutations() : ContainerUtil.emptyList();
        List<RowMutation> deleteMutations = this.myDeletedRows.stream().map(this.myModel::getRow).filter(Objects::nonNull).map(row -> new RowMutation((DataConsumer.Row)row, DatabaseMutatorImpl.createColumnsUpdateData(row, this.myModel.getColumns()))).collect(Collectors.toList());
        List<DataRequest.DmlRequest> requests = ContainerUtil.newArrayList();
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newDeleteRequest), deleteMutations));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newUpdateRequest), updateMutations));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newInsertRequest), insertMutations));
        requests = ContainerUtil.filter((Collection)requests, Objects::nonNull);
        if (!requests.isEmpty()) {
            DataRequest request = DataRequest.newCompositeRequest(this.myHookUp, requests);
            this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_DONE);
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    public void clearPendingChanges() {
        this.myDeletedRows.clear();
        this.myInsertedRows.clear();
        this.myStorage.clear();
        this.myFailed = false;
    }

    @Override
    public boolean hasMutatedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "hasMutatedRows"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseMutatorImpl", "hasMutatedRows"));
        }
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column : columns.asIterable()) {
                MutationData mutation = this.myStorage.get(row, column);
                if (mutation == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getMutationType"));
        }
        return !row.isValid(this.myModel) ? null : (this.isInsertedRow(row) ? MutationType.INSERT : (this.isDeletedRow(row) ? MutationType.DELETE : (this.myStorage.isModified(row) ? MutationType.MODIFY : null)));
    }

    @NotNull
    protected List<ModelIndex<DataConsumer.Row>> getPhysicalRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getPhysicalRows"));
        }
        List list = rows.asIterable().map(row -> this.isInsertedRow((ModelIndex<DataConsumer.Row>)row) && row.isValid(this.myModel) ? null : row).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getPhysicalRows"));
        }
        return list;
    }

    protected void processRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull DataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "processRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DatabaseMutatorImpl", "processRequest"));
        }
        this.myHookUp.processRequest(source, request, reloadPolicy);
    }

    @NotNull
    protected List<DataConsumer.Column> getPhysicalColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnIndices) {
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getPhysicalColumns"));
        }
        List list = columnIndices.asIterable().transform(columnIndex -> {
            DataConsumer.Column column = this.myModel.getColumn((ModelIndex<DataConsumer.Column>)columnIndex);
            return DbImplUtil.isComputedColumn(column) ? null : column;
        }).filter(Condition.NOT_NULL).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getPhysicalColumns"));
        }
        return list;
    }

    @NotNull
    private static List<ModelIndex<DataConsumer.Row>> sortedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "sortedRows"));
        }
        List<ModelIndex<DataConsumer.Row>> list = rows.asList().stream().sorted((o1, o2) -> Integer.compare(o1.asInteger(), o2.asInteger())).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "sortedRows"));
        }
        return list;
    }

    private boolean doDeleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "doDeleteRows"));
        }
        this.myFailed = false;
        List physicalRows = ContainerUtil.filter(this.getPhysicalRows(rows), (Condition)Condition.NOT_NULL);
        this.myStorage.delete(physicalRows);
        this.synchronizeModels(rows);
        if (physicalRows.size() == 0 || this.getDatabaseTable() == null) {
            return false;
        }
        this.myDeletedRows.addAll(physicalRows);
        return true;
    }

    private void synchronizeModels(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "synchronizeModels"));
        }
        List sorted = ContainerUtil.filter(DatabaseMutatorImpl.sortedRows(rows), this::isInsertedRow);
        ModelIndex first = (ModelIndex)ContainerUtil.getFirstItem((List)sorted);
        if (first == null) {
            return;
        }
        for (int i2 = sorted.size() - 1; i2 > -1; --i2) {
            ModelIndex rowIdx = (ModelIndex)sorted.get(i2);
            if (!this.isInsertedRow(rowIdx)) continue;
            this.myInsertedRows.remove(rowIdx);
            List<ModelIndex<DataConsumer.Row>> indexes = this.findBiggerRowIndices(rowIdx);
            this.myInsertedRows.removeAll(indexes);
            JBIterable.from(indexes).transform(idx -> ModelIndex.forRow(this.myModel, idx.asInteger() - 1)).filter(idx -> idx.isValid(this.myModel)).forEach(this.myInsertedRows::add);
            this.myModel.removeRows(ModelIndexSet.forRows(this.myModel, rowIdx.asInteger()));
            this.myStorage.shiftUp(rowIdx);
        }
    }

    @NotNull
    private List<ModelIndex<DataConsumer.Row>> findBiggerRowIndices(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/DatabaseMutatorImpl", "findBiggerRowIndices"));
        }
        List list = ContainerUtil.filter(this.myInsertedRows, row -> {
            if (rowIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/DatabaseMutatorImpl", "lambda$findBiggerRowIndices$11"));
            }
            return row.asInteger() > rowIdx.asInteger();
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "findBiggerRowIndices"));
        }
        return list;
    }

    @NotNull
    private List<RowMutation> createInsertMutations() {
        ArrayList rowMutations = ContainerUtil.newArrayList();
        for (ModelIndex modelIndex : this.myInsertedRows) {
            DataConsumer.Row row = this.myModel.getRow(modelIndex);
            if (row == null) continue;
            List<ColumnUpdateData> infos = this.createUpdateData(modelIndex);
            rowMutations.add(new RowMutation(row, infos));
        }
        ArrayList arrayList = rowMutations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createInsertMutations"));
        }
        return arrayList;
    }

    @NotNull
    private List<RowMutation> createUpdateMutations() {
        ArrayList rowMutations = ContainerUtil.newArrayList();
        for (Integer i2 : this.myStorage) {
            DataConsumer.Row row;
            ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, (int)i2);
            if (this.isInsertedRow(rowIdx) || !this.myStorage.isModified(rowIdx) || !rowIdx.isValid(this.myModel) || (row = this.myModel.getRow(rowIdx)) == null) continue;
            List<ColumnUpdateData> infos = this.createUpdateData(rowIdx);
            rowMutations.add(new RowMutation(row, infos));
        }
        ArrayList arrayList = rowMutations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createUpdateMutations"));
        }
        return arrayList;
    }

    @NotNull
    private List<ColumnUpdateData> createUpdateData(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createUpdateData"));
        }
        ArrayList infos = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < this.myStorage.columnCount(); ++i2) {
            DataConsumer.Column column;
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, i2);
            MutationData mutation = this.myStorage.get(row, columnIdx);
            if (mutation == null || !columnIdx.isValid(this.myModel) || (column = this.myModel.getColumn(columnIdx)) == null) continue;
            infos.add(new ColumnUpdateData(column, mutation.getValue()));
        }
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createUpdateData"));
        }
        return arrayList;
    }

    private void doInsertRow(@NotNull DataConsumer.Row newRow) {
        if (newRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRow", "com/intellij/database/datagrid/DatabaseMutatorImpl", "doInsertRow"));
        }
        this.myFailed = false;
        int newRowIdx = this.myModel.getRowCount();
        this.myModel.addRows(ContainerUtil.newSmartList((Object)newRow));
        this.myInsertedRows.add(ModelIndex.forRow(this.myModel, newRowIdx));
        ArrayList mutations = ContainerUtil.newArrayList();
        List<DataConsumer.Column> columns = this.getPhysicalColumns(this.myModel.getColumnIndices());
        for (DataConsumer.Column column : columns) {
            ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, newRowIdx);
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, column.columnNum);
            CellMutation mutation = new CellMutation(rowIdx, columnIdx, MutationType.INSERT, column.getValue(newRow));
            mutations.add(mutation);
            this.myStorage.set(rowIdx, columnIdx, mutation);
        }
    }

    @Nullable
    private DasTable getDatabaseTable() {
        return this.myHookUp.getDatabaseTable();
    }

    private void notifyRequestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "notifyRequestFinished"));
        }
        this.myHookUp.notifyRequestFinished(source, success);
    }

    private void notifyUpdateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int count) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "notifyUpdateCountReceived"));
        }
        this.myHookUp.notifyUpdateCountReceived(source, count);
    }

    private boolean isReadOnly() {
        return this.myHookUp.isReadOnly();
    }

    private boolean hasDifferentRowTypes(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseMutatorImpl", "hasDifferentRowTypes"));
        }
        boolean hasInserted = false;
        boolean hasNotInserted = false;
        for (ModelIndex rowModelIndex : rows.asIterable()) {
            boolean inserted = this.isInsertedRow(rowModelIndex);
            hasInserted |= inserted;
            hasNotInserted |= !inserted;
        }
        return hasInserted && hasNotInserted;
    }

    @Nullable
    private DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column) {
        return this.myHookUp.getDatabaseColumn(column);
    }

    @NotNull
    private MutationType getMutationTypeWhenMutate(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getMutationTypeWhenMutate"));
        }
        MutationType mutationType = this.isInsertedRow(row) ? MutationType.INSERT : MutationType.MODIFY;
        if (mutationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "getMutationTypeWhenMutate"));
        }
        return mutationType;
    }

    @Nullable
    private DataRequest.DmlRequest createRequest(@NotNull PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest> creator, @NotNull List<RowMutation> mutations) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createRequest"));
        }
        if (mutations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createRequest"));
        }
        if (mutations.isEmpty() || this.getDatabaseTable() == null) {
            return null;
        }
        ArrayList sorted = ContainerUtil.newArrayList(mutations);
        ContainerUtil.sort((List)sorted);
        DmlMutationContext context = new DmlMutationContext(sorted, this.myModel.getColumns(), this.getDatabaseTable());
        return (DataRequest.DmlRequest)creator.fun((Object)this.myHookUp, (Object)context);
    }

    @NotNull
    private static List<ColumnUpdateData> createColumnsUpdateData(@NotNull DataConsumer.Row row, @NotNull List<DataConsumer.Column> columns) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createColumnsUpdateData"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createColumnsUpdateData"));
        }
        List list = ContainerUtil.map(columns, column -> {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DatabaseMutatorImpl", "lambda$createColumnsUpdateData$12"));
            }
            return new ColumnUpdateData((DataConsumer.Column)column, column.getValue(row));
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseMutatorImpl", "createColumnsUpdateData"));
        }
        return list;
    }

    private static void setForceSuccess(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl", "setForceSuccess"));
        }
        DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
        if (requestSource != null) {
            requestSource.setForceSuccess(true);
        }
    }

    private class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private MyRequestListener() {
        }

        @Override
        public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, String message, Throwable th) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener", "error"));
            }
            DatabaseMutatorImpl.this.myFailed = message != null || th != null;
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener", "updateCountReceived"));
            }
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener", "requestFinished"));
            }
            DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
            if (!success || requestSource == null || !requestSource.isErrorReported()) {
                return;
            }
            DatabaseMutatorImpl.this.myFailed = requestSource.getRows().size() != requestSource.getUpdateCount();
        }
    }
}

