/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.BatchRecords;
import com.intellij.database.dbimport.DeColumnWithState;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReaderTask
implements Runnable {
    private static final int MAX_RECORD_SIZE = 0x100000;
    private static final String IO_ERROR = "Import failed. Can't access file.";
    private static final String MANY_CHARS_ERROR = "There are very big records in file or file format is incorrect";
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final Project myProject;
    @NotNull
    private final LinkedTransferQueue<BatchRecords> myTransferQueue;
    @NotNull
    private final ImportInfo myInfo;
    private final Charset myCharset;
    private final int myCharCount;
    private final int myMaxCharCount;
    private volatile boolean myStopped;
    @NotNull
    private CsvFormatParser myParser;

    ReaderTask(@NotNull ImportInfo info, @NotNull InputStream inputStream, @NotNull Project project, @NotNull LinkedTransferQueue<BatchRecords> transferQueue, @NotNull Charset charset, int charCount) throws IOException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (transferQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferQueue", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        this.myParser = new CsvFormatParser(info.getFormat());
        this.myInfo = info;
        this.myInputStream = inputStream;
        this.myProject = project;
        this.myCharset = charset;
        this.myCharCount = charCount;
        this.myMaxCharCount = charCount + 0x100000;
        this.myTransferQueue = transferQueue;
    }

    @NotNull
    private static CsvFormatParser createParserWithoutHeader(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ReaderTask", "createParserWithoutHeader"));
        }
        CsvFormat format = info.getFormat();
        CsvFormat withoutHeader = new CsvFormat(format.dataRecord, null, format.rowNumbers);
        CsvFormatParser csvFormatParser = new CsvFormatParser(withoutHeader);
        if (csvFormatParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ReaderTask", "createParserWithoutHeader"));
        }
        return csvFormatParser;
    }

    void stop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String unparsedText = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.myInputStream, this.myCharset));){
            String text;
            while ((text = this.getText(br)) != null) {
                text = unparsedText + text;
                if (text.length() >= this.myMaxCharCount) {
                    throw new BigRecordException();
                }
                CsvDocumentDataHookUp.CsvMarkup markup = this.myParser.parse(text);
                CsvDocumentDataHookUp.CsvRecord lastRecord = (CsvDocumentDataHookUp.CsvRecord)ContainerUtil.getLastItem(markup == null ? null : markup.getRecords());
                BatchRecords batch = this.getBatch(markup);
                if (batch.getRecords().isEmpty()) {
                    unparsedText = text;
                    continue;
                }
                int end = ((CsvDocumentDataHookUp.CsvRecord)ObjectUtils.assertNotNull((Object)lastRecord)).range.getEndOffset();
                unparsedText = text.substring(Math.min(text.length(), end));
                this.send(batch);
                if (this.myParser.getDataFormat().headerRecord == null) continue;
                this.myParser = ReaderTask.createParserWithoutHeader(this.myInfo);
            }
        }
        catch (BigRecordException e) {
            this.onError(e.getMessage());
        }
        catch (InterruptedException e) {
            this.onStop();
        }
        catch (IOException e) {
            this.onError(IO_ERROR);
        }
        finally {
            this.poisonQueue();
        }
    }

    @NotNull
    private BatchRecords getBatch(@Nullable CsvDocumentDataHookUp.CsvMarkup markup) {
        ArrayList parameters = ContainerUtil.newArrayList();
        if (markup == null) {
            BatchRecords batchRecords = new BatchRecords(parameters, 0L);
            if (batchRecords == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ReaderTask", "getBatch"));
            }
            return batchRecords;
        }
        long chars = 0L;
        for (DataConsumer.Row row : markup.rows) {
            ArrayList line = ContainerUtil.newArrayList();
            for (DataConsumer.Column column : markup.columns) {
                String value = (String)column.getValue(row);
                if (value != null) {
                    chars += (long)value.length();
                }
                if (!this.checkHasColumnWithThisNumber(column)) continue;
                line.add(value);
            }
            parameters.add(ArrayUtil.toStringArray((Collection)line));
        }
        BatchRecords batchRecords = new BatchRecords(parameters, chars);
        if (batchRecords == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ReaderTask", "getBatch"));
        }
        return batchRecords;
    }

    private boolean checkHasColumnWithThisNumber(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ReaderTask", "checkHasColumnWithThisNumber"));
        }
        for (DeColumn deColumn : this.myInfo.getColumns()) {
            if (deColumn instanceof DeColumnWithState && ((DeColumnWithState)deColumn).getNumber() != column.columnNum) continue;
            return true;
        }
        return false;
    }

    private void poisonQueue() {
        if (this.myStopped) {
            return;
        }
        this.send(BatchRecords.POISON);
        this.myStopped = true;
    }

    private void send(@NotNull BatchRecords parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/ReaderTask", "send"));
        }
        try {
            this.myTransferQueue.transfer(parameters);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onStop();
        }
    }

    private void onStop() {
        if (this.myStopped) {
            return;
        }
        this.myTransferQueue.clear();
        this.myTransferQueue.offer(BatchRecords.POISON);
        this.myStopped = true;
    }

    private void onError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/ReaderTask", "onError"));
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myProject);
    }

    private String getText(@NotNull BufferedReader myReader) throws InterruptedException {
        if (myReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myReader", "com/intellij/database/dbimport/ReaderTask", "getText"));
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            int character;
            char[] buffer = new char[this.myCharCount];
            int count = myReader.read(buffer);
            if (count == -1) {
                return null;
            }
            if (count == 0) {
                return "";
            }
            String lastChar = String.valueOf(buffer[count - 1]);
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, count)));
            while (!this.isRecordSeparator(lastChar) && (character = myReader.read()) != -1) {
                lastChar = StringUtil.convertLineSeparators((String)String.valueOf((char)character));
                sb.append(lastChar);
                if (sb.length() < this.myMaxCharCount) continue;
                throw new BigRecordException();
            }
            return sb.toString();
        }
        catch (IOException e) {
            this.onError(IO_ERROR);
            return null;
        }
    }

    private boolean isRecordSeparator(String string) {
        String recordSeparator = this.myParser.getDataFormat().dataRecord.recordSeparator;
        return StringUtil.equals((CharSequence)string, (CharSequence)recordSeparator);
    }

    private static class BigRecordException
    extends RuntimeException {
        BigRecordException() {
            super(ReaderTask.MANY_CHARS_ERROR);
        }
    }
}

