/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaModelImpl
implements MetaModel {
    private final Set<Couple<ObjectKind>> objectClasses;
    private final Map<String, ObjectKind> objectKinds;
    private final Set<ObjectKind> namespaces;
    private final MultiMap<ObjectKind, List<ObjectKind>> paths;

    @NotNull
    public static MetaModelBuilder builder() {
        MetaModelBuilder metaModelBuilder = new MetaModelBuilder();
        if (metaModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "builder"));
        }
        return metaModelBuilder;
    }

    private MetaModelImpl(@NotNull Set<Couple<ObjectKind>> objectClasses, @NotNull Map<String, ObjectKind> objectKinds) {
        if (objectClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClasses", "com/intellij/database/model/MetaModelImpl", "<init>"));
        }
        if (objectKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKinds", "com/intellij/database/model/MetaModelImpl", "<init>"));
        }
        this.paths = MultiMap.createLinkedSet();
        this.objectClasses = objectClasses;
        this.objectKinds = objectKinds;
        this.namespaces = Collections.unmodifiableSet((Set)JBIterable.from(objectClasses).transform(Functions.pairSecond()).filter(k -> k == ObjectKind.SCHEMA || k == ObjectKind.DATABASE).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        JBIterable traversal = ((JBTreeTraverser)new JBTreeTraverser(this::getChildKinds).withRoot((Object)ObjectKind.ROOT)).traverse(TreeTraversal.INTERLEAVED_DFS);
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)traversal.typedIterator();
        while (it.hasNext()) {
            ObjectKind next = (ObjectKind)it.next();
            List list = it.backtrace().toList();
            if (list.size() <= objectKinds.size()) {
                this.paths.putValue((Object)next, (Object)ContainerUtil.newUnmodifiableList((List)list));
            }
            visited.add(next);
            if (visited.size() != objectKinds.size()) continue;
            break;
        }
    }

    @NotNull
    public Set<Couple<ObjectKind>> getKindCouples() {
        Set<Couple<ObjectKind>> set = this.objectClasses;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getKindCouples"));
        }
        return set;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable<ObjectKind> jBIterable = this.getChildKinds(ObjectKind.ROOT);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getRootNamespaceKinds"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/MetaModelImpl", "getChildKinds"));
        }
        JBIterable jBIterable = JBIterable.from(this.getKindCouples()).filter(Conditions.compose((Function)Functions.pairFirst(), (Condition)Conditions.is((Object)kind))).transform(Functions.pairSecond());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getChildKinds"));
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set<ObjectKind> set = this.namespaces;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getNamespaces"));
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind) {
        if (!this.paths.containsKey((Object)kind)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getPathsToRoot"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)this.paths.get((Object)kind));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModelImpl", "getPathsToRoot"));
        }
        return jBIterable;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        if (code == null) {
            return null;
        }
        if ((code = code.trim()).isEmpty()) {
            return null;
        }
        return this.objectKinds.get(code);
    }

    public String toString() {
        return this.objectKinds.values().toString();
    }

    public static final class MetaModelBuilder<T> {
        private final Set<Couple<ObjectKind>> a = ContainerUtil.newLinkedHashSet();
        private final Map<String, ObjectKind> b = ContainerUtil.newLinkedHashMap();

        public MetaModelBuilder() {
            this.b.put("root", ObjectKind.ROOT);
        }

        public MetaModelBuilder<T> put(ObjectKind parent, ObjectKind child) {
            this.a.add((Couple<ObjectKind>)Couple.of((Object)parent, (Object)child));
            this.b.put(child.code(), child);
            return this;
        }

        public MetaModelImpl build() {
            return new MetaModelImpl(Collections.unmodifiableSet(this.a), Collections.unmodifiableMap(this.b));
        }
    }
}

