/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraLikeColumn;
import com.intellij.database.model.oracle.OraObjectType;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraObjectTypeAttribute
extends OraLikeColumn,
BasicArrangedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public OraObjectType getObjectType();

    @Override
    @Nullable
    default public OraObjectType getDbParent() {
        return this.getObjectType();
    }

    @Override
    @Nullable
    default public OraObjectType getMajorObject() {
        return this.getObjectType();
    }

    default public @Nullable PositioningNamingFamily<@NotNull ? extends OraObjectTypeAttribute> getParentFamily() {
        return null;
    }

    @Nullable
    default public OraSchema getSchema() {
        OraObjectType objectType = this.getObjectType();
        return objectType != null ? objectType.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public short getPosition() {
        return 0;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DataType getDataType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getDataType"));
        }
        return dataType;
    }

    @Override
    default public boolean isNotNull() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean notNull;
        DataType dataType;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "exportProperties"));
        }
        short position = this.getPosition();
        if (position != 0) {
            consumer.accept("Position", PropertyConverter.export(position));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((dataType = this.getDataType()) != null && dataType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("DataType", PropertyConverter.export(dataType));
        }
        if (notNull = this.isNotNull()) {
            consumer.accept("NotNull", PropertyConverter.export(notNull));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Position", "Name", "NameSurrogate", "Comment", "DataType", "NotNull");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectTypeAttribute", "getPropertyNames"));
        }
        return list;
    }
}

