/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GeneralSettingsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private JCheckBox myShowQueryResultsInCheckBox;
    private JCheckBox myShowErrorBalloonCheckbox;
    private JBCheckBox myReviewParametersCheckBox;
    private ComboBox myInsideStatementCombo;
    private ComboBox myOutsideStatementCombo;
    private ComboBox mySelectionPresentCombo;
    private JCheckBox myPreviewRowsCheckBox;
    private JTextField myPreviewRowsTextField;
    private JBCheckBox myDdlConfirmOnClose;

    public GeneralSettingsComponent() {
        this.$$$setupUI$$$();
        this.myInsideStatementCombo.addItem((Object)"Ask what to execute");
        this.myInsideStatementCombo.addItem((Object)"Smallest statement");
        this.myInsideStatementCombo.addItem((Object)"Largest statement");
        this.myInsideStatementCombo.addItem((Object)"Largest statement or batch");
        this.myInsideStatementCombo.addItem((Object)"Whole script");
        this.myOutsideStatementCombo.addItem((Object)"Nothing");
        this.myOutsideStatementCombo.addItem((Object)"Whole script");
        this.myOutsideStatementCombo.addItem((Object)"Everything below caret");
        this.mySelectionPresentCombo.addItem((Object)"Exactly as one statement");
        this.mySelectionPresentCombo.addItem((Object)"Exactly as statements");
        this.mySelectionPresentCombo.addItem((Object)"Smart expand to script");
        this.myInsideStatementCombo.setMinLength(30);
        this.myOutsideStatementCombo.setMinLength(30);
        this.mySelectionPresentCombo.setMinLength(30);
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/GeneralSettingsComponent", "getComponent"));
        }
        return jPanel;
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/GeneralSettingsComponent", "reset"));
        }
        this.myShowQueryResultsInCheckBox.setSelected(!settings.isReuseResultTab());
        this.myShowErrorBalloonCheckbox.setSelected(settings.isShowErrorInEditor());
        this.myReviewParametersCheckBox.setSelected(settings.alwaysReviewParameters);
        this.myInsideStatementCombo.setSelectedIndex(settings.executeInsideOption - 1);
        this.myOutsideStatementCombo.setSelectedIndex(settings.executeOutsideOption - 1);
        this.mySelectionPresentCombo.setSelectedIndex(settings.executeSelectionOption - 1);
        this.myPreviewRowsCheckBox.setSelected(settings.loadSlowDocumentation);
        this.myPreviewRowsTextField.setText(String.valueOf(settings.previewRows));
        this.myDdlConfirmOnClose.setSelected(settings.ddlConfirmLoss);
    }

    public void apply(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/GeneralSettingsComponent", "apply"));
        }
        settings.setReuseResultTab(!this.myShowQueryResultsInCheckBox.isSelected());
        settings.setShowErrorInEditor(this.myShowErrorBalloonCheckbox.isSelected());
        settings.alwaysReviewParameters = this.myReviewParametersCheckBox.isSelected();
        settings.executeInsideOption = this.myInsideStatementCombo.getSelectedIndex() + 1;
        settings.executeOutsideOption = this.myOutsideStatementCombo.getSelectedIndex() + 1;
        settings.executeSelectionOption = this.mySelectionPresentCombo.getSelectedIndex() + 1;
        settings.loadSlowDocumentation = this.myPreviewRowsCheckBox.isSelected();
        settings.previewRows = StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0);
        settings.ddlConfirmLoss = this.myDdlConfirmOnClose.isSelected();
        DatabaseSettings.fireSettingsChanged();
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/GeneralSettingsComponent", "isModified"));
        }
        if (settings.isReuseResultTab() == this.myShowQueryResultsInCheckBox.isSelected()) {
            return true;
        }
        if (settings.isShowErrorInEditor() != this.myShowErrorBalloonCheckbox.isSelected()) {
            return true;
        }
        if (settings.alwaysReviewParameters != this.myReviewParametersCheckBox.isSelected()) {
            return true;
        }
        if (settings.executeInsideOption - 1 != this.myInsideStatementCombo.getSelectedIndex()) {
            return true;
        }
        if (settings.executeOutsideOption - 1 != this.myOutsideStatementCombo.getSelectedIndex()) {
            return true;
        }
        if (settings.executeSelectionOption - 1 != this.mySelectionPresentCombo.getSelectedIndex()) {
            return true;
        }
        if (settings.loadSlowDocumentation != this.myPreviewRowsCheckBox.isSelected()) {
            return true;
        }
        if (settings.previewRows != StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0)) {
            return true;
        }
        return settings.ddlConfirmLoss != this.myDdlConfirmOnClose.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ComboBox comboBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(14, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(13, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Console");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        JBCheckBox jBCheckBox3 = new JBCheckBox();
        this.myShowErrorBalloonCheckbox = jBCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/DatabaseBundle").getString("jdbc.console.property.label.error.balloon"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox4 = new JBCheckBox();
        this.myShowQueryResultsInCheckBox = jBCheckBox4;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("messages/DatabaseBundle").getString("jdbc.console.property.label.new.tab"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("otherwise execute:");
        jPanel.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myOutsideStatementCombo = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(6, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("When inside a statement execute:");
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myInsideStatementCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(5, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReviewParametersCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Always review parameters before execution");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Execute in Console");
        jPanel.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("for selection execute:");
        jPanel.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySelectionPresentCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(7, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Quick Documentation");
        jPanel.add((Component)titledSeparator3, new GridConstraints(8, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        JBCheckBox jBCheckBox5 = new JBCheckBox();
        this.myPreviewRowsCheckBox = jBCheckBox5;
        jBCheckBox5.setText("Show first rows");
        jPanel.add((Component)jBCheckBox5, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Number of preview rows:");
        jPanel.add((Component)jBLabel4, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JBTextField jBTextField = new JBTextField();
        this.myPreviewRowsTextField = jBTextField;
        jBTextField.setColumns(6);
        jBTextField.setText("");
        jBTextField.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("DDL editor");
        jPanel.add((Component)titledSeparator4, new GridConstraints(11, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myDdlConfirmOnClose = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show confirmation on close");
        jPanel.add((Component)jBCheckBox, new GridConstraints(12, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox3);
        jBLabel4.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

