/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseStructure
extends AbstractTreeStructure {
    private final DbPsiFacade myFacade;
    private final DatabaseViewOptions myViewOptions;

    public DatabaseStructure(DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        this.myViewOptions = viewOptions;
        this.myFacade = facade;
    }

    public Object getRootElement() {
        return this.myFacade;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFacade.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getProject"));
        }
        return project;
    }

    public boolean isAlwaysLeaf(Object element) {
        return DatabaseStructure.isAlwaysLeafImpl(element);
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        return o instanceof DasTableChild || o instanceof DasRoutine || o instanceof DasObject && ((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasSynonym || o instanceof MoreObject;
    }

    public static boolean isDatabaseObject(Object element) {
        return element instanceof DbElement || element instanceof GroupElement;
    }

    public Object[] getChildElements(Object element) {
        if (element == this.myFacade) {
            return ArrayUtil.toObjectArray((Collection)this.myFacade.getDataSources());
        }
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (element instanceof MoreObject) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return ArrayUtil.toObjectArray((Collection)DatabaseStructure.getChildrenImpl(element, this.myViewOptions).toList());
    }

    public Object getParentElement(Object o) {
        if (o == this.myFacade) {
            return null;
        }
        if (o instanceof DbDataSource) {
            return this.myFacade;
        }
        if (o instanceof MoreObject) {
            return ((MoreObject)o).parent;
        }
        return o instanceof PsiElement ? DatabaseStructure.getParentImpl((PsiElement)o, this.myViewOptions) : null;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions) {
        boolean groupOption;
        DbElement root2;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        if (viewOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewOptions", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        Object object = o instanceof GroupElement ? ((GroupElement)((Object)o)).parentElement : (o instanceof DbDataSource || o instanceof DbNamespaceImpl ? DatabaseStructure.getTopSingleRoot((DbElement)o) : (root2 = o instanceof DbElement ? (DbElement)o : null));
        if (root2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
            }
            return jBIterable;
        }
        ObjectKind kidKind = o instanceof GroupElement ? ((GroupElement)((Object)o)).childKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getDatabaseDialect(root2).getMetaModel();
        boolean isNamespace = metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind == ObjectKind.NONE) {
            List groups = ContainerUtil.newSmartList();
            int w = 0;
            Object delegate = root2.getDelegate();
            Iterable<ObjectKind> childKinds = delegate instanceof BasicElement ? ((BasicElement)delegate).getFamilyKinds() : DatabaseStructure.getChildKinds(metaModel, rootKind);
            for (ObjectKind childKind : childKinds) {
                ++w;
                if (!viewOptions.SHOW_EMPTY_GROUPS && root2.getDbChildren(DbElement.class, childKind).isEmpty()) continue;
                groups.add(new GroupElement(root2, childKind, w, viewOptions));
            }
            if (groups.size() > 1) {
                JBIterable<?> jBIterable = DatabaseStructure.appendMoreObject(o, groups);
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
                }
                return jBIterable;
            }
        }
        JBIterable children = root2.getDbChildren(DbElement.class, kidKind);
        if (!viewOptions.SHOW_TABLE_DETAILS && o instanceof DasTable) {
            children = children.filter(DasUtil.byKind((ObjectKind)ObjectKind.COLUMN));
        }
        if (root2 instanceof DasNamespace) {
            try {
                Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter((DatabaseSystem)root2.getDataSource());
                children = children.filter(condition);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        JBIterable<?> jBIterable = DatabaseStructure.appendMoreObject(o, children);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        return jBIterable;
    }

    private static Iterable<ObjectKind> getChildKinds(@NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        if (mm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mm", "com/intellij/database/view/DatabaseStructure", "getChildKinds"));
        }
        if (parentKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentKind", "com/intellij/database/view/DatabaseStructure", "getChildKinds"));
        }
        return JBIterable.from((Iterable)mm.getKindCouples()).filter(c -> {
            if (parentKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentKind", "com/intellij/database/view/DatabaseStructure", "lambda$getChildKinds$0"));
            }
            return c.first == parentKind;
        }).map(c -> (ObjectKind)c.second);
    }

    protected static JBIterable<?> appendMoreObject(@NotNull Object o, Iterable<?> children) {
        DasModel model;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DatabaseStructure", "appendMoreObject"));
        }
        if (o instanceof DbDataSource && ((model = DatabaseStructure.getModel((DatabaseSystem)((DbDataSource)o), DasModel.class)) == DasUtil.emptyModel() || model instanceof BasicModModel && (model.getModelRoots().isEmpty() || DatabaseStructure.modelHasHiddenNamespaces((BasicModModel)model)))) {
            MoreObject moreObject = new MoreObject((DbElement)((DbDataSource)o));
            return JBIterable.from(children).append((Object)moreObject);
        }
        return JBIterable.from(children);
    }

    @Nullable
    public static <T extends DasModel> T getModel(DatabaseSystem ds, Class<T> clazz) {
        LocalDataSource local = DatabaseStructure.getLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Nullable
    public static LocalDataSource getLocalDataSource(DatabaseSystem ds) {
        if (ds instanceof LocalDataSource) {
            return (LocalDataSource)ds;
        }
        if (ds instanceof DbDataSource) {
            return DatabaseStructure.getLocalDataSource(((DbDataSource)ds).getDelegate());
        }
        return null;
    }

    private static boolean modelHasHiddenNamespaces(@NotNull BasicModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/DatabaseStructure", "modelHasHiddenNamespaces"));
        }
        BasicRoot root2 = model.getRoot();
        if (root2.hasHiddenNamespaces()) {
            return true;
        }
        if (root2 instanceof BasicMultiDatabaseRoot) {
            NamingFamily<? extends BasicDatabase> databases = ((BasicMultiDatabaseRoot)root2).getDatabases();
            for (BasicDatabase basicDatabase : databases) {
                if (!basicDatabase.isVisible() || !basicDatabase.hasHiddenNamespaces()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        boolean groupOption;
        DbElement grandPa;
        DbElement root2;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DatabaseStructure", "getParentImpl"));
        }
        if (!o.isValid()) {
            return null;
        }
        Object object = o instanceof GroupElement ? ((GroupElement)o).parentElement : (root2 = o instanceof DbElement ? ((DbElement)o).getDbParent() : null);
        while (root2 instanceof DbNamespaceImpl && (grandPa = root2.getDbParent()) != null && DatabaseStructure.getTopSingleRoot(grandPa) != grandPa) {
            root2 = grandPa;
        }
        if (root2 == null) {
            return null;
        }
        ObjectKind kidKind = o instanceof DbElement ? ((DbElement)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getDatabaseDialect(root2).getMetaModel();
        boolean isNamespace = metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind != ObjectKind.NONE) {
            GroupElement result = null;
            int w = 0;
            for (Couple couple : metaModel.getKindCouples()) {
                if (couple.first != rootKind) continue;
                ++w;
                if (couple.second != kidKind) continue;
                result = new GroupElement(root2, (ObjectKind)couple.second, w, viewOptions);
            }
            if (w > 1 && result != null) {
                return result;
            }
        }
        return root2;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element instanceof DbElement) {
            DbNodeDescriptor dbNodeDescriptor = new DbNodeDescriptor((DbElement)element, parentDescriptor);
            if (dbNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return dbNodeDescriptor;
        }
        if (element == this.myFacade) {
            Root root2 = new Root(this.myFacade);
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return root2;
        }
        if (element instanceof GroupElement) {
            GroupNode groupNode = new GroupNode((GroupElement)((Object)element), parentDescriptor);
            if (groupNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return groupNode;
        }
        if (element instanceof MoreObject) {
            MoreObjectNode moreObjectNode = new MoreObjectNode((MoreObject)element, parentDescriptor);
            if (moreObjectNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return moreObjectNode;
        }
        throw new AssertionError((Object)("Unable how to make a visual node for " + element.toString() + " (" + element.getClass().getSimpleName() + ")"));
    }

    @NotNull
    static DbElement getTopSingleRoot(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseStructure", "getTopSingleRoot"));
        }
        CommonProcessors.FindFirstAndOnlyProcessor processor = new CommonProcessors.FindFirstAndOnlyProcessor();
        DbElement e = element;
        while (true) {
            processor.reset();
            ContainerUtil.process((Iterable)e.getDbChildren(DasNamespace.class, ObjectKind.NONE), (Processor)processor);
            DasNamespace value = (DasNamespace)processor.getFoundValue();
            if (!(value instanceof DbElement)) break;
            e = (DbElement)value;
        }
        DbElement dbElement = e;
        if (dbElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getTopSingleRoot"));
        }
        return dbElement;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return true;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.getProject()).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = DatabaseStructure.asyncCommitDocuments((Project)this.getProject());
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    static class MoreObjectNode
    extends PresentableNodeDescriptor
    implements DataProvider {
        private final MoreObject myElement;

        public MoreObjectNode(MoreObject element, @NotNull NodeDescriptor parentDescriptor) {
            if (parentDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDescriptor", "com/intellij/database/view/DatabaseStructure$MoreObjectNode", "<init>"));
            }
            super(parentDescriptor.getProject(), parentDescriptor);
            this.myElement = element;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getNavigatable();
            }
            return null;
        }

        @NotNull
        protected Navigatable getNavigatable() {
            Navigatable navigatable = new Navigatable(){

                public void navigate(boolean requestFocus) {
                    DatabaseView databaseView = DatabaseView.getDatabaseView(((MoreObjectNode)this).myElement.parent.getProject());
                    JBPopup popup = DataSourceUiUtil.buildHiddenNamespacesPopup(((MoreObjectNode)this).myElement.parent);
                    RelativePoint point = this.calcPoint(databaseView);
                    if (point != null) {
                        popup.show(point);
                    } else {
                        popup.showInBestPositionFor(DataManager.getInstance().getDataContext((Component)((Object)databaseView)));
                    }
                }

                @Nullable
                private RelativePoint calcPoint(@NotNull DatabaseView databaseView) {
                    TreePath path;
                    if (databaseView == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseView", "com/intellij/database/view/DatabaseStructure$MoreObjectNode$1", "calcPoint"));
                    }
                    JTree tree = databaseView.getTreeBuilder().getTree();
                    if (tree == null) {
                        return null;
                    }
                    int[] rows = tree.getSelectionRows();
                    Integer row = rows != null && rows.length > 0 ? rows[rows.length - 1] : -1;
                    TreePath treePath = path = row != -1 ? tree.getPathForRow(row) : null;
                    if (path == null) {
                        return null;
                    }
                    Rectangle bounds = tree.getPathBounds(path);
                    if (bounds == null) {
                        return null;
                    }
                    bounds.y += bounds.height;
                    return new RelativePoint((Component)tree, bounds.getLocation());
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
            if (navigatable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure$MoreObjectNode", "getNavigatable"));
            }
            return navigatable;
        }

        protected void update(PresentationData presentation) {
            presentation.addText(new PresentableNodeDescriptor.ColoredFragment("More Schemas...", SimpleTextAttributes.GRAY_ATTRIBUTES));
        }

        public Object getElement() {
            return this.myElement;
        }

        public int getWeight() {
            return Integer.MAX_VALUE;
        }
    }

    protected static class MoreObject {
        public final DbElement parent;

        public MoreObject(DbElement parent) {
            this.parent = parent;
        }
    }

    public static class GroupElement
    extends FakePsiElement {
        final DbElement parentElement;
        final ObjectKind childKind;
        final String name;
        final int weight;
        final DatabaseViewOptions viewOptions;

        GroupElement(@NotNull DbElement parentElement, @NotNull ObjectKind childKind, int weight, DatabaseViewOptions viewOptions) {
            if (parentElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/database/view/DatabaseStructure$GroupElement", "<init>"));
            }
            if (childKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/database/view/DatabaseStructure$GroupElement", "<init>"));
            }
            this.childKind = childKind;
            this.parentElement = parentElement;
            this.weight = weight;
            this.viewOptions = viewOptions;
            this.name = StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)childKind, (DatabaseDialect)DbImplUtil.getDatabaseDialect(parentElement)));
        }

        @NotNull
        public Project getProject() {
            Project project = this.parentElement.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure$GroupElement", "getProject"));
            }
            return project;
        }

        public PsiFile getContainingFile() {
            return this.parentElement.getContainingFile();
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.ObjectGroup;
        }

        public PsiElement getParent() {
            return this.parentElement;
        }

        public boolean isValid() {
            return this.parentElement.isValid();
        }

        @NotNull
        public ObjectKind getChildKind() {
            ObjectKind objectKind = this.childKind;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure$GroupElement", "getChildKind"));
            }
            return objectKind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            GroupElement folder = (GroupElement)((Object)o);
            if (!this.parentElement.equals(folder.parentElement)) {
                return false;
            }
            return this.childKind.equals(folder.childKind);
        }

        public int hashCode() {
            int result = this.parentElement.hashCode();
            result = 31 * result + this.childKind.hashCode();
            return result;
        }
    }

    private static class GroupNode
    extends PresentableNodeDescriptor
    implements DataProvider {
        final GroupElement element;

        public GroupNode(GroupElement element, NodeDescriptor parentDescriptor) {
            super(parentDescriptor.getProject(), parentDescriptor);
            this.element = element;
        }

        protected void update(PresentationData presentation) {
            int size;
            presentation.setIcon(this.element.getIcon(true));
            presentation.addText(this.element.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            int n = size = this.element.isValid() ? DatabaseStructure.getChildrenImpl((Object)this.element, this.element.viewOptions).size() : 0;
            if (size > 0) {
                presentation.addText(" " + size, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }

        public int getWeight() {
            return this.element.weight;
        }

        public Object getElement() {
            return this.element;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return DbNodeDescriptor.getData(dataId, this.element.parentElement);
        }
    }

    private static class Root
    extends PresentableNodeDescriptor {
        final DbPsiFacade element;

        public Root(DbPsiFacade facade) {
            super(facade.getProject(), null);
            this.element = facade;
        }

        protected void update(PresentationData presentation) {
        }

        public Object getElement() {
            return this.element;
        }
    }
}

