/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.fragments;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.fragments.SqlCodeFragment;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeFragmentImpl
extends SqlFileImpl
implements SqlCodeFragment {
    private PsiElement myContext;
    private boolean myPhysical;
    private FileViewProvider myViewProvider;
    private GlobalSearchScope myScope;
    private final SqlLanguageDialect myDialect;
    private final IElementType myElementType;

    public SqlCodeFragmentImpl(SqlCodeFragmentImpl file, String text) {
        this(file.getProject(), file.getSqlLanguage(), file.getElementType(), file.getName(), text, file.isPhysical());
    }

    public IElementType getElementType() {
        return this.myElementType;
    }

    public SqlCodeFragmentImpl(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull IElementType elementType, @NotNull @NonNls String fileName, @NotNull CharSequence text, boolean isPhysical) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "<init>"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "<init>"));
        }
        super(PsiManagerEx.getInstanceEx((Project)project).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(fileName, (Language)dialect, text), isPhysical));
        this.myScope = null;
        this.myElementType = elementType;
        this.myDialect = dialect;
        this.myPhysical = isPhysical;
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
        FragmentElementType type = new FragmentElementType(this.myDialect, elementType);
        this.init((IElementType)type, (IElementType)type);
    }

    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    protected SqlCodeFragmentImpl clone() {
        SqlCodeFragmentImpl clone = (SqlCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        clone.myViewProvider = cloneViewProvider;
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.init(this.getContentElementType(), this.getContentElementType());
        return clone;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public void setContext(@Nullable PsiElement context) {
        this.myContext = context;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myScope;
    }

    public static class ErrorFilter
    extends HighlightErrorFilter {
        public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl$ErrorFilter", "shouldHighlightErrorElement"));
            }
            PsiFile file = element.getContainingFile();
            if (!(file instanceof SqlCodeFragment)) {
                return true;
            }
            return !StringUtil.isEmptyOrSpaces((String)file.getText());
        }
    }

    public static class FragmentElementType
    extends IFileElementType {
        private final IElementType myElementType;

        public FragmentElementType(@NotNull SqlLanguageDialect dialect, @NotNull IElementType elementType) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl$FragmentElementType", "<init>"));
            }
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl$FragmentElementType", "<init>"));
            }
            super("SQL_CODE_FRAGMENT", (Language)dialect, false);
            this.myElementType = elementType;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            SqlCompositeElementImpl psi = new SqlCompositeElementImpl(chameleon);
            return this.doParseContents(chameleon, (PsiElement)psi);
        }

        protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
            if (chameleon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl$FragmentElementType", "doParseContents"));
            }
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/fragments/SqlCodeFragmentImpl$FragmentElementType", "doParseContents"));
            }
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            Project project = ((TreeElement)chameleon).getManager().getProject();
            PsiBuilder builder = factory.createBuilder(project, chameleon);
            PsiParser parser = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createParser(project);
            return parser.parse(this.myElementType, builder);
        }
    }
}

