/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import org.jetbrains.annotations.NotNull;

public class SqlStringLiteralEscaper
extends LiteralTextEscaper<SqlStringLiteralExpression> {
    public SqlStringLiteralEscaper(SqlStringLiteralExpression element) {
        super((PsiLanguageInjectionHost)element);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        IElementType elementType = SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost);
        if (elementType == SqlTokens.SQL_STRING_TOKEN) {
            outChars.append(SqlStringLiteralManipulator.unescapeSqlStringCharacters(rangeInsideHost.substring(((SqlStringLiteralExpression)this.myHost).getText()), elementType));
        } else {
            outChars.append(((SqlStringLiteralExpression)this.myHost).getText(), rangeInsideHost.getStartOffset(), rangeInsideHost.getEndOffset());
        }
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int offset;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "getOffsetInHost"));
        }
        IElementType elementType = SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost);
        if (elementType == SqlTokens.SQL_STRING_TOKEN) {
            String text = rangeInsideHost.substring(((SqlStringLiteralExpression)this.myHost).getText());
            int i2 = text.indexOf("''");
            int len = text.length();
            for (offset = offsetInDecoded; i2 < len && i2 < offset && i2 >= 0; ++offset) {
                i2 = text.indexOf("''", i2 + 1);
            }
        }
        if ((offset += rangeInsideHost.getStartOffset()) < rangeInsideHost.getStartOffset()) {
            offset = rangeInsideHost.getStartOffset();
        }
        if (offset > rangeInsideHost.getEndOffset()) {
            offset = rangeInsideHost.getEndOffset();
        }
        return offset;
    }

    public boolean isOneLine() {
        return SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost) != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
    }
}

