/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlNamedStubElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlUseDatabaseStatementElementType
extends SqlNamedStubElementType<SqlUseDatabaseStatement> {
    public static final String SEPARATOR = "||";
    private SqlReferenceElementType myReferenceType;

    public static NotNullFunction<String, SqlUseDatabaseStatementElementType> factory(SqlReferenceElementType referenceType) {
        return name -> new SqlUseDatabaseStatementElementType((String)name, referenceType);
    }

    public SqlUseDatabaseStatementElementType(String debugName, SqlReferenceElementType referenceType) {
        super(debugName);
        this.myReferenceType = referenceType;
    }

    @Override
    @NotNull
    public SqlNamedElementStub<SqlUseDatabaseStatement> createStub(@NotNull SqlUseDatabaseStatement psi, StubElement parentStub) {
        StringRef name;
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlUseDatabaseStatementElementType", "createStub"));
        }
        List refs = psi.getUseReferences();
        if (refs.isEmpty()) {
            name = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (SqlReferenceExpression ref : refs) {
                String text;
                if (sb.length() > 0) {
                    sb.append(SEPARATOR);
                }
                if (StringUtil.isQuotedString((String)(text = ref.getText())) && text.charAt(0) == '\'') {
                    text = "\"" + StringUtil.unquoteString((String)text) + "\"";
                }
                sb.append(text);
            }
            name = StringRef.fromString((String)sb.toString());
        }
        SqlNamedElementStub<SqlUseDatabaseStatement> sqlNamedElementStub = new SqlNamedElementStub<SqlUseDatabaseStatement>(parentStub, this, name);
        if (sqlNamedElementStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlUseDatabaseStatementElementType", "createStub"));
        }
        return sqlNamedElementStub;
    }

    @Override
    protected SqlNameElement getNameElement(SqlUseDatabaseStatement psi) {
        return (SqlNameElement)ContainerUtil.getFirstItem((List)psi.getUseReferences());
    }

    public SqlReferenceElementType getReferenceType() {
        return this.myReferenceType;
    }
}

