/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.DomElementListCellRenderer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.converters.ParentStateReference;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.IdentifiedWithParent;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebflowIdentifiedAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator", "annotate"));
        }
        if (!(psiElement instanceof XmlTag)) {
            return;
        }
        PsiFile containingFile = holder.getCurrentAnnotationSession().getFile();
        if (!(containingFile instanceof XmlFile)) {
            return;
        }
        if (containingFile instanceof JspFile) {
            return;
        }
        WebflowDomModelManager webflowDomModelManager = WebflowDomModelManager.getInstance(psiElement.getProject());
        if (!webflowDomModelManager.isWebflow((XmlFile)containingFile)) {
            return;
        }
        DomElement domElement = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
        if (!(domElement instanceof IdentifiedWithParent)) {
            return;
        }
        if (!domElement.isValid()) {
            return;
        }
        WebflowModel model = webflowDomModelManager.getWebflowModel((XmlFile)containingFile);
        if (model == null) {
            return;
        }
        WebflowIdentifiedAnnotator.installParentIdentified((IdentifiedWithParent)domElement, holder);
        WebflowIdentifiedAnnotator.installInheritingIdentified(model, (IdentifiedWithParent)domElement, holder);
        if (domElement instanceof ViewState) {
            WebflowIdentifiedAnnotator.installViewStateValidator((ViewState)domElement, holder);
        }
    }

    private static void installViewStateValidator(ViewState viewState, AnnotationHolder holder) {
        PsiClass modelClass = viewState.getModelClass();
        if (modelClass == null) {
            return;
        }
        Project project = viewState.getManager().getProject();
        String viewStateId = viewState.getId().getStringValue();
        assert (viewStateId != null);
        String viewStateName = StringUtil.capitalize((String)viewStateId);
        if (!PsiNameHelper.getInstance((Project)project).isIdentifier(viewStateName)) {
            return;
        }
        String validationMethodSignature = "public void validate" + viewStateName + "(" + "org.springframework.binding.validation.ValidationContext" + " context) {}";
        PsiMethod templateMethod = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(validationMethodSignature, null);
        PsiMethod validationMethod = modelClass.findMethodBySignature(templateMethod, true);
        if (validationMethod != null) {
            NavigationGutterIconBuilder.create((Icon)AllIcons.Nodes.Jsf.Validator).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.identified.view.state.validator.method.tooltip", new Object[0])).setTarget((Object)validationMethod).install(holder, (PsiElement)viewState.getXmlTag());
            return;
        }
        Module module = viewState.getModule();
        if (module == null) {
            return;
        }
        String modelName = viewState.getModel().getStringValue();
        SpringModel springModel = SpringManager.getInstance((Project)project).getCombinedModel(module);
        SpringBeanPointer validatorBean = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)(modelName + "Validator"));
        if (validatorBean == null) {
            return;
        }
        PsiClass validatorBeanClass = validatorBean.getBeanClass();
        if (validatorBeanClass == null) {
            return;
        }
        String validatorMethodSignature = "public void validate" + viewStateName + "(" + modelClass.getQualifiedName() + " model, " + "org.springframework.binding.validation.ValidationContext" + " context) {}";
        PsiMethod validatorTemplateMethod = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(validatorMethodSignature, null);
        PsiMethod validatorMethod = validatorBeanClass.findMethodBySignature(validatorTemplateMethod, true);
        if (validatorMethod != null) {
            NavigationGutterIconBuilder.create((Icon)AllIcons.Nodes.Jsf.Validator).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.identified.view.state.validator.bean.tooltip", new Object[0])).setTarget((Object)validatorMethod).install(holder, (PsiElement)viewState.getXmlTag());
        }
    }

    private static void installParentIdentified(final IdentifiedWithParent identifiedWithParent, AnnotationHolder holder) {
        if (!DomUtil.hasXml(identifiedWithParent.getParentAction())) {
            return;
        }
        NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridingMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(WebflowBundle.message("navigation.related.parent.tooltip", new Object[0])).setEmptyPopupText(WebflowBundle.message("navigation.related.parent.not.found", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends DomElement>>(){

            @NotNull
            protected Collection<? extends DomElement> compute() {
                PsiReference[] references;
                if (!identifiedWithParent.isValid()) {
                    List list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator$1", "compute"));
                    }
                    return list;
                }
                XmlAttributeValue element = identifiedWithParent.getParentAction().getXmlAttributeValue();
                if (element == null) {
                    List list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator$1", "compute"));
                    }
                    return list;
                }
                for (PsiReference reference : references = element.getReferences()) {
                    if (!(reference instanceof ParentStateReference)) continue;
                    Identified identified = ((ParentStateReference)reference).getIdentified();
                    List list = ContainerUtil.createMaybeSingletonList((Object)identified);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator$1", "compute"));
                    }
                    return list;
                }
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator$1", "compute"));
                }
                return list;
            }
        }).install(holder, (PsiElement)identifiedWithParent.getXmlTag());
    }

    private static void installInheritingIdentified(WebflowModel model, IdentifiedWithParent identifiedWithParent, AnnotationHolder holder) {
        XmlAttributeValue value = identifiedWithParent.getId().getXmlAttributeValue();
        if (value == null) {
            return;
        }
        SmartList relatedFlowFiles = new SmartList((Object)model.getFlowFile().getVirtualFile());
        for (Flow flow : model.getFlow().getAllRelatedFlows()) {
            relatedFlowFiles.add(DomUtil.getFile((DomElement)flow).getVirtualFile());
        }
        GlobalSearchScope relatedFlowsSearchScope = GlobalSearchScope.filesScope((Project)identifiedWithParent.getManager().getProject(), (Collection)relatedFlowFiles);
        final Query search = ReferencesSearch.search((PsiElement)value, (SearchScope)relatedFlowsSearchScope);
        if (search.findFirst() == null) {
            return;
        }
        NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridenMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR).setAlignment(GutterIconRenderer.Alignment.CENTER).setCellRenderer((PsiElementListCellRenderer)new DomElementListCellRenderer("")).setTooltipText(WebflowBundle.message("navigation.related.inheriting.tooltip", new Object[0])).setPopupTitle(WebflowBundle.message("navigation.related.inheriting", StringUtil.pluralize((String)identifiedWithParent.getPresentation().getTypeName()))).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends DomElement>>(){

            @NotNull
            protected Collection<? extends DomElement> compute() {
                Collection all = search.findAll();
                ArrayList result = new ArrayList(all.size());
                for (PsiReference reference : all) {
                    IdentifiedWithParent inheriting = (IdentifiedWithParent)DomUtil.findDomElement((PsiElement)reference.getElement(), IdentifiedWithParent.class, (boolean)true);
                    ContainerUtil.addIfNotNull(result, (Object)inheriting);
                }
                ArrayList arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowIdentifiedAnnotator$2", "compute"));
                }
                return arrayList;
            }
        }).install(holder, (PsiElement)identifiedWithParent.getXmlTag());
    }
}

