/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.css.util.CssConstants;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.CssColorGutterRenderer;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CssColorAnnotator
implements Annotator {
    private static final String COLOR_DECLARATION = "color";

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        boolean annotateEveryTerm;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/browse/CssColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/browse/CssColorAnnotator", "annotate"));
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (webEditorOptions == null || !webEditorOptions.isShowCssColorPreviewInGutter() && !webEditorOptions.isShowCssInlineColorPreview()) {
            return;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)psiElement);
        boolean bl = annotateEveryTerm = descriptorProvider != null && descriptorProvider.isColorTermsSupported();
        if (psiElement instanceof CssTerm && annotateEveryTerm) {
            CssColorAnnotator.annotateTerm((CssTerm)psiElement, holder);
        } else if (psiElement instanceof CssFunction) {
            CssColorAnnotator.annotateFunction((CssFunction)psiElement, holder);
        } else if (!annotateEveryTerm && psiElement instanceof CssDeclaration) {
            CssColorAnnotator.annotateDeclaration((CssDeclaration)psiElement, holder);
        }
    }

    private static void annotateDeclaration(@NotNull CssDeclaration declaration, final @NotNull AnnotationHolder holder) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateDeclaration"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateDeclaration"));
        }
        CssTermList value = declaration.getValue();
        if (value != null) {
            final HashSet annotatedTerms = ContainerUtil.newHashSet();
            Collection propertyDescriptors = declaration.getDescriptors();
            if (propertyDescriptors.isEmpty()) {
                CssTerm[] terms;
                if (declaration.getPropertyName().toLowerCase(Locale.US).contains(COLOR_DECLARATION) && (terms = (CssTerm[])PsiTreeUtil.getChildrenOfType((PsiElement)declaration.getValue(), CssTerm.class)) != null) {
                    for (CssTerm term : terms) {
                        CssColorAnnotator.annotateTerm(term, holder);
                    }
                }
                return;
            }
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                final CssValueMatchData matchData = value.matchWithValueDescriptor(propertyDescriptor.getValueDescriptor());
                value.acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                    public void visitCssTerm(CssTerm _term) {
                        if (!annotatedTerms.contains(_term)) {
                            for (CssValueDescriptor valueDescriptor = matchData.findDeepestDescriptorForElement((PsiElement)_term); valueDescriptor != null; valueDescriptor = valueDescriptor.getParent()) {
                                if (!(valueDescriptor instanceof CssColorValue) && (!(valueDescriptor instanceof CssInlineValue) || !CssColorAnnotator.COLOR_DECLARATION.equals(((CssInlineValue)valueDescriptor).getRefId())) && (!(valueDescriptor instanceof CssPropertyReferenceValue) || !((CssPropertyReferenceValue)valueDescriptor).getPropertyName().contains(CssColorAnnotator.COLOR_DECLARATION))) continue;
                                annotatedTerms.add(_term);
                                CssColorAnnotator.annotateTerm(_term, holder);
                                break;
                            }
                        }
                    }

                    public void visitCssElement(CssElement element) {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                });
            }
        }
    }

    private static void annotateFunction(@NotNull CssFunction function, @NotNull AnnotationHolder holder) {
        Color color;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateFunction"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateFunction"));
        }
        String functionName = function.getName();
        if (CssConstants.COLOR_FUNCTIONS.contains(functionName) && !CssPsiColorUtil.isInsideColorFunction((PsiElement)function) && (color = CssColorGutterRenderer.getColor((PsiElement)function)) != null) {
            CssColorAnnotator.annotate((PsiElement)function, color, holder);
        }
    }

    private static void annotateTerm(@NotNull CssTerm term, @NotNull AnnotationHolder holder) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateTerm"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/browse/CssColorAnnotator", "annotateTerm"));
        }
        if (term.getFirstChild() instanceof CssFunction) {
            return;
        }
        if (CssPsiColorUtil.isColorTerm(term)) {
            String termText = term.getText();
            Color color = ColorMap.getColor((String)termText);
            if (color == null || termText.startsWith("#")) {
                color = CssColorGutterRenderer.getColor((PsiElement)term);
            }
            if (color != null) {
                CssColorAnnotator.annotate((PsiElement)term, color, holder);
            }
        }
    }

    private static void annotate(@NotNull PsiElement psiElement, @NotNull Color color, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/browse/CssColorAnnotator", "annotate"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR_DECLARATION, "com/intellij/psi/css/browse/CssColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/browse/CssColorAnnotator", "annotate"));
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        Annotation annotation = holder.createInfoAnnotation(psiElement, null);
        if (webEditorOptions != null && webEditorOptions.isShowCssColorPreviewInGutter()) {
            annotation.setGutterIconRenderer((GutterIconRenderer)new CssColorGutterRenderer(psiElement));
        }
        if (webEditorOptions != null && webEditorOptions.isShowCssInlineColorPreview()) {
            annotation.setTextAttributes(CssColorAnnotator.createTextAttributeKey(color));
        }
    }

    @NotNull
    private static TextAttributesKey createTextAttributeKey(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR_DECLARATION, "com/intellij/psi/css/browse/CssColorAnnotator", "createTextAttributeKey"));
        }
        TextAttributes attributes = new TextAttributes();
        Color background = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        Color mix = ColorUtil.mix((Color)background, (Color)color, (double)((double)color.getAlpha() / 255.0));
        attributes.setBackgroundColor(mix);
        attributes.setForegroundColor((Color)(ColorUtil.isDark((Color)mix.darker()) ? Gray._254 : Gray._1));
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)("CSS_COLOR_" + mix.hashCode()), (TextAttributes)attributes);
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/browse/CssColorAnnotator", "createTextAttributeKey"));
        }
        return textAttributesKey;
    }
}

