/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.inspections.jam.SpringIntegrationJamModelInspectionBase;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamAggregator;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamFilter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamGateway;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPublisher;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamRouter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamServiceActivator;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamSplitter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamTransformer;
import com.intellij.spring.model.SpringBeanPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedMessageChannelInspection
extends SpringIntegrationJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "checkClass"));
        }
        JamService jamService = JamService.getJamService((Project)aClass.getProject());
        for (PsiMethod psiMethod : aClass.getMethods()) {
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getAggregator(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getFilter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getGateway(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getPublisher(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getRouter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getServiceActivator(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getSplitter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getTransformer(jamService, psiMethod), holder);
        }
    }

    private static void checkMethodEndpoint(@Nullable SpringIntegrationJamMethodEndpoint methodEndpoint, ProblemsHolder holder) {
        if (methodEndpoint == null) {
            return;
        }
        for (JamStringAttributeElement<SpringBeanPointer> attributeElement : methodEndpoint.getChannelAttributes()) {
            PsiLiteral psiElement = attributeElement.getPsiLiteral();
            if (psiElement == null) continue;
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)attributeElement.getValue();
            if (springBeanPointer == null) {
                holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.cannot.find.channel", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            PsiClass beanClass = springBeanPointer.getBeanClass();
            if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.integration.MessageChannel") || InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.messaging.MessageChannel")) continue;
            holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.bean.must.be.message.channel", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static SpringIntegrationJamSplitter getSplitter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getSplitter"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getSplitter"));
        }
        return (SpringIntegrationJamSplitter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamSplitter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamRouter getRouter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getRouter"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getRouter"));
        }
        return (SpringIntegrationJamRouter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamRouter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamServiceActivator getServiceActivator(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getServiceActivator"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getServiceActivator"));
        }
        return (SpringIntegrationJamServiceActivator)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamServiceActivator.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamAggregator getAggregator(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getAggregator"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getAggregator"));
        }
        return (SpringIntegrationJamAggregator)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamAggregator.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamFilter getFilter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getFilter"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getFilter"));
        }
        return (SpringIntegrationJamFilter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamFilter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamGateway getGateway(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getGateway"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getGateway"));
        }
        return (SpringIntegrationJamGateway)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamGateway.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamPublisher getPublisher(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getPublisher"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getPublisher"));
        }
        return (SpringIntegrationJamPublisher)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamPublisher.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamTransformer getTransformer(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jamService", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getTransformer"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection", "getTransformer"));
        }
        return (SpringIntegrationJamTransformer)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamTransformer.METHOD_META});
    }
}

