/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.braces;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

public class MarkdownQuoteHandler
implements QuoteHandler {
    private static final TokenSet QUOTE_TYPES = TokenSet.create((IElementType[])new IElementType[]{MarkdownTokenTypes.EMPH, MarkdownTokenTypes.BACKTICK, MarkdownTokenTypes.SINGLE_QUOTE, MarkdownTokenTypes.DOUBLE_QUOTE, MarkdownTokenTypes.CODE_FENCE_START});

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        int prev;
        boolean seekPrev;
        CharSequence charsSequence = iterator.getDocument().getCharsSequence();
        TextRange current = MarkdownQuoteHandler.getRangeOfThisType(charsSequence, offset);
        boolean isBacktick = charsSequence.charAt(offset) == '`';
        boolean bl = seekPrev = isBacktick || current.getStartOffset() - 1 >= 0 && !Character.isWhitespace(charsSequence.charAt(current.getStartOffset() - 1));
        if (seekPrev && (prev = MarkdownQuoteHandler.locateNextPosition(charsSequence, charsSequence.charAt(offset), current.getStartOffset() - 1, -1)) != -1) {
            return MarkdownQuoteHandler.getRangeOfThisType(charsSequence, prev).getLength() <= current.getLength();
        }
        return current.getLength() % 2 == 0 && (!isBacktick || offset > (current.getStartOffset() + current.getEndOffset()) / 2);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean isBacktick;
        IElementType tokenType = iterator.getTokenType();
        if (!QUOTE_TYPES.contains(tokenType)) {
            return false;
        }
        CharSequence chars = iterator.getDocument().getCharsSequence();
        boolean bl = isBacktick = chars.charAt(offset) == '`';
        if (isBacktick && this.isClosingQuote(iterator, offset)) {
            return false;
        }
        return MarkdownQuoteHandler.getRangeOfThisType(chars, offset).getLength() != 1 || (offset <= 0 || Character.isWhitespace(chars.charAt(offset - 1))) && (offset + 1 >= chars.length() || Character.isWhitespace(chars.charAt(offset + 1)));
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        TextRange current = MarkdownQuoteHandler.getRangeOfThisType(charsSequence, offset);
        int next = MarkdownQuoteHandler.locateNextPosition(charsSequence, charsSequence.charAt(offset), current.getEndOffset(), 1);
        return next == -1 || MarkdownQuoteHandler.getRangeOfThisType(charsSequence, next).getLength() < current.getLength();
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return false;
    }

    private static TextRange getRangeOfThisType(@NotNull CharSequence charSequence, int offset) {
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "org/intellij/plugins/markdown/braces/MarkdownQuoteHandler", "getRangeOfThisType"));
        }
        int length = charSequence.length();
        char c = charSequence.charAt(offset);
        int l = offset;
        int r = offset;
        while (l - 1 >= 0 && charSequence.charAt(l - 1) == c) {
            --l;
        }
        while (r + 1 < length && charSequence.charAt(r + 1) == c) {
            ++r;
        }
        return TextRange.create((int)l, (int)(r + 1));
    }

    private static int locateNextPosition(@NotNull CharSequence haystack, char needle, int from, int dx) {
        if (haystack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "haystack", "org/intellij/plugins/markdown/braces/MarkdownQuoteHandler", "locateNextPosition"));
        }
        while (from >= 0 && from < haystack.length()) {
            char currentChar = haystack.charAt(from);
            if (currentChar == needle) {
                return from;
            }
            if (currentChar == '\n') {
                return -1;
            }
            from += dx;
        }
        return -1;
    }
}

