/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class SplitTextEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    private static final String FIRST_EDITOR = "first_editor";
    private static final String SECOND_EDITOR = "second_editor";
    private static final String SPLIT_LAYOUT = "split_layout";
    @NotNull
    protected final FileEditorProvider myFirstProvider;
    @NotNull
    protected final FileEditorProvider mySecondProvider;
    @NotNull
    private final String myEditorTypeId;

    public SplitTextEditorProvider(@NotNull FileEditorProvider firstProvider, @NotNull FileEditorProvider secondProvider) {
        if (firstProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstProvider", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "<init>"));
        }
        if (secondProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondProvider", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "<init>"));
        }
        this.myFirstProvider = firstProvider;
        this.mySecondProvider = secondProvider;
        this.myEditorTypeId = "split-provider[" + this.myFirstProvider.getEditorTypeId() + ";" + this.mySecondProvider.getEditorTypeId() + "]";
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "accept"));
        }
        return this.myFirstProvider.accept(project, file) && this.mySecondProvider.accept(project, file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditor"));
        }
        FileEditor fileEditor = this.createEditorAsync(project, file).build();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditor"));
        }
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        String string = this.myEditorTypeId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getEditorTypeId"));
        }
        return string;
    }

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditorAsync"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditorAsync"));
        }
        final AsyncFileEditorProvider.Builder firstBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.myFirstProvider, project, file);
        final AsyncFileEditorProvider.Builder secondBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.mySecondProvider, project, file);
        AsyncFileEditorProvider.Builder builder = new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return SplitTextEditorProvider.this.createSplitEditor(firstBuilder.build(), secondBuilder.build());
            }
        };
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "createEditorAsync"));
        }
        return builder;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Attribute attribute;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "readState"));
        }
        Element child = sourceElement.getChild(FIRST_EDITOR);
        FileEditorState firstState = null;
        if (child != null) {
            firstState = this.myFirstProvider.readState(child, project, file);
        }
        child = sourceElement.getChild(SECOND_EDITOR);
        FileEditorState secondState = null;
        if (child != null) {
            secondState = this.mySecondProvider.readState(child, project, file);
        }
        String layoutName = (attribute = sourceElement.getAttribute(SPLIT_LAYOUT)) != null ? attribute.getValue() : null;
        SplitFileEditor.MyFileEditorState myFileEditorState = new SplitFileEditor.MyFileEditorState(layoutName, firstState, secondState);
        if (myFileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "readState"));
        }
        return myFileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "writeState"));
        }
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return;
        }
        SplitFileEditor.MyFileEditorState compositeState = (SplitFileEditor.MyFileEditorState)state;
        Element child = new Element(FIRST_EDITOR);
        if (compositeState.getFirstState() != null) {
            this.myFirstProvider.writeState(compositeState.getFirstState(), project, child);
            targetElement.addContent(child);
        }
        child = new Element(SECOND_EDITOR);
        if (compositeState.getSecondState() != null) {
            this.mySecondProvider.writeState(compositeState.getSecondState(), project, child);
            targetElement.addContent(child);
        }
        if (compositeState.getSplitLayout() != null) {
            targetElement.setAttribute(SPLIT_LAYOUT, compositeState.getSplitLayout());
        }
    }

    protected abstract FileEditor createSplitEditor(@NotNull FileEditor var1, @NotNull FileEditor var2);

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    @NotNull
    private static AsyncFileEditorProvider.Builder getBuilderFromEditorProvider(final @NotNull FileEditorProvider provider, final @NotNull Project project, final @NotNull VirtualFile file) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getBuilderFromEditorProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getBuilderFromEditorProvider"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getBuilderFromEditorProvider"));
        }
        if (provider instanceof AsyncFileEditorProvider) {
            AsyncFileEditorProvider.Builder builder = ((AsyncFileEditorProvider)provider).createEditorAsync(project, file);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getBuilderFromEditorProvider"));
            }
            return builder;
        }
        AsyncFileEditorProvider.Builder builder = new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return provider.createEditor(project, file);
            }
        };
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider", "getBuilderFromEditorProvider"));
        }
        return builder;
    }
}

