/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.sdk.impl;

import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.AppEngineSdkManager;
import com.intellij.appengine.sdk.impl.AppEngineSdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppEngineSdkManagerImpl
extends AppEngineSdkManager {
    private final Map<String, AppEngineSdkImpl> myPath2Sdk = new THashMap();

    @Override
    @NotNull
    public AppEngineSdk findSdk(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/intellij/appengine/sdk/impl/AppEngineSdkManagerImpl", "findSdk"));
        }
        if (!this.myPath2Sdk.containsKey(sdkPath = StringUtil.trimEnd((String)sdkPath, (String)"/"))) {
            this.myPath2Sdk.put(sdkPath, new AppEngineSdkImpl(sdkPath));
        }
        AppEngineSdk appEngineSdk = this.myPath2Sdk.get(sdkPath);
        if (appEngineSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkManagerImpl", "findSdk"));
        }
        return appEngineSdk;
    }

    @Override
    @NotNull
    public List<? extends AppEngineSdk> getValidSdks() {
        List<? extends AppEngineSdk> list = AppEngineWebIntegration.getInstance().getSdkForConfiguredDevServers();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkManagerImpl", "getValidSdks"));
        }
        return list;
    }
}

