/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.server.instance;

import com.intellij.appengine.server.instance.AppEngineServerModel;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class AppEngineRunConfigurationEditor
extends SettingsEditor<CommonModel>
implements PanelWithAnchor {
    private JPanel myMainPanel;
    private JComboBox myArtifactComboBox;
    private JTextField myPortField;
    private RawCommandLineEditor myServerParametersEditor;
    private JBLabel myWebArtifactToDeployLabel;
    private JBLabel myPortLabel;
    private JBLabel myServerParametersLabel;
    private final Project myProject;
    private Artifact myLastSelectedArtifact;
    private JComponent anchor;

    public AppEngineRunConfigurationEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myArtifactComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineRunConfigurationEditor.this.onArtifactChanged();
            }
        });
        this.setAnchor((JComponent)this.myWebArtifactToDeployLabel);
    }

    private void onArtifactChanged() {
        Artifact selectedArtifact = this.getSelectedArtifact();
        if (!Comparing.equal((Object)this.myLastSelectedArtifact, (Object)selectedArtifact)) {
            if (this.myLastSelectedArtifact != null) {
                BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myMainPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
            }
            if (selectedArtifact != null) {
                BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myMainPanel, (Project)this.myProject, (Artifact)selectedArtifact, (boolean)true);
            }
            this.myLastSelectedArtifact = selectedArtifact;
        }
    }

    protected void resetEditorFrom(CommonModel s) {
        AppEngineServerModel serverModel = (AppEngineServerModel)s.getServerModel();
        this.myPortField.setText(String.valueOf(serverModel.getLocalPort()));
        Artifact artifact = serverModel.getArtifact();
        this.myArtifactComboBox.setSelectedItem(artifact);
        if (artifact == null && this.myArtifactComboBox.getItemCount() == 1) {
            this.myArtifactComboBox.setSelectedIndex(0);
        }
        this.myServerParametersEditor.setDialogCaption("Server Parameters");
        this.myServerParametersEditor.setText(serverModel.getServerParameters());
    }

    protected void applyEditorTo(CommonModel s) throws ConfigurationException {
        AppEngineServerModel serverModel = (AppEngineServerModel)s.getServerModel();
        try {
            serverModel.setPort(Integer.parseInt(this.myPortField.getText()));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("'" + this.myPortField.getText() + "' is not valid port number");
        }
        serverModel.setServerParameters(this.myServerParametersEditor.getText());
        serverModel.setArtifact(this.getSelectedArtifact());
    }

    private Artifact getSelectedArtifact() {
        return (Artifact)this.myArtifactComboBox.getSelectedItem();
    }

    @NotNull
    protected JComponent createEditor() {
        AppEngineUtil.setupAppEngineArtifactCombobox(this.myProject, this.myArtifactComboBox, false);
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/server/instance/AppEngineRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myWebArtifactToDeployLabel.setAnchor(anchor);
        this.myPortLabel.setAnchor(anchor);
        this.myServerParametersLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel;
        JTextField jTextField;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myWebArtifactToDeployLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Artifact to deploy:");
        jBLabel3.setDisplayedMnemonic('D');
        jBLabel3.setDisplayedMnemonicIndex(12);
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myArtifactComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myPortLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Port:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myServerParametersLabel = jBLabel = new JBLabel();
        jBLabel.setText("Server parameters:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerParametersEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        jBLabel3.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

