/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanNameViewResolverFactory
extends ViewResolverFactory {
    public String getBeanClass() {
        return "org.springframework.web.servlet.view.BeanNameViewResolver";
    }

    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        return Collections.singleton(new BeanNameViewResolver());
    }

    public static class BeanNameViewResolver
    extends ViewResolver {
        public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
            if (StringUtil.isEmpty((String)viewName)) {
                return null;
            }
            Collection<SpringModel> models = this.getModels(springMVCModel);
            for (SpringModel model : models) {
                SpringBeanPointer beanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)viewName);
                if (beanPointer == null) continue;
                return beanPointer.getPsiElement();
            }
            return null;
        }

        @Nullable
        public PsiElement resolveFinalView(String viewName, SpringMVCModel springMVCModel) {
            if (StringUtil.isEmpty((String)viewName)) {
                return null;
            }
            Collection<SpringModel> models = this.getModels(springMVCModel);
            for (SpringModel model : models) {
                CommonSpringBean bean;
                SpringBeanPointer beanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)viewName);
                if (beanPointer == null || !((bean = beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                String url = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"url");
                if (url == null) {
                    return null;
                }
                WebDirectoryElement webDirectoryElement = springMVCModel.findWebDirectoryElement(url);
                return webDirectoryElement != null ? webDirectoryElement.getOriginalFile() : null;
            }
            return null;
        }

        public List<LookupElement> getAllViews(SpringMVCModel context) {
            SpringModel springModel = (SpringModel)ContainerUtil.getFirstItem((Collection)context.getAllModels());
            if (springModel == null) {
                return Collections.emptyList();
            }
            PsiClass servletView = SpringCommonUtils.findLibraryClass((Module)springModel.getModule(), (String)"org.springframework.web.servlet.View");
            if (servletView == null) {
                return Collections.emptyList();
            }
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)servletView).withInheritors();
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            Collection<SpringModel> models = this.getModels(context);
            for (SpringModel model : models) {
                List beanPointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                variants.addAll(ContainerUtil.mapNotNull((Collection)beanPointers, SpringConverterUtil::createCompletionVariant));
            }
            return variants;
        }

        public String bindToElement(PsiElement element) {
            return null;
        }

        @NotNull
        public String handleElementRename(String newElementName) {
            String string = newElementName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/BeanNameViewResolverFactory$BeanNameViewResolver", "handleElementRename"));
            }
            return string;
        }

        protected Collection<SpringModel> getModels(SpringMVCModel context) {
            return context.getAllModels();
        }
    }
}

