/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.mvc.UrlViewResolverType;
import com.intellij.spring.model.xml.mvc.ViewResolverBeanName;
import com.intellij.spring.model.xml.mvc.ViewResolverContentNegotiation;
import com.intellij.spring.model.xml.mvc.ViewResolverFreeMarker;
import com.intellij.spring.model.xml.mvc.ViewResolverGroovy;
import com.intellij.spring.model.xml.mvc.ViewResolverJsp;
import com.intellij.spring.model.xml.mvc.ViewResolverTiles;
import com.intellij.spring.model.xml.mvc.ViewResolverVelocity;
import com.intellij.spring.model.xml.mvc.ViewResolvers;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.CompositeViewResolver;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ViewResolversViewResolverFactory
extends ViewResolverFactory {
    protected String getBeanClass() {
        return null;
    }

    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        return bean instanceof ViewResolvers;
    }

    protected Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        ViewResolvers viewResolvers = (ViewResolvers)bean;
        List<ViewResolver> resolvers = ViewResolversViewResolverFactory.determineViewResolvers(viewResolvers, model);
        return Collections.singleton(new CompositeViewResolver(resolvers));
    }

    private static List<ViewResolver> determineViewResolvers(ViewResolvers viewResolvers, SpringModel model) {
        SmartList resolvers = new SmartList();
        block0: for (DomElement domElement : DomUtil.getDefinedChildren((DomElement)viewResolvers, (boolean)true, (boolean)false)) {
            SpringBeanPointer beanPointer;
            if (domElement instanceof ViewResolverContentNegotiation) continue;
            ViewResolver resolver = ViewResolversViewResolverFactory.createBuiltinResolver(domElement, model);
            if (resolver != null) {
                resolvers.add(resolver);
                continue;
            }
            Object psiClass = domElement instanceof SpringBean ? PsiTypesUtil.getPsiClass((PsiType)((SpringBean)domElement).getBeanType()) : (domElement instanceof SpringRef ? ((beanPointer = (SpringBeanPointer)((SpringRef)domElement).getBean().getValue()) != null ? beanPointer.getBeanClass() : null) : (domElement instanceof ViewResolverTiles ? DomJavaUtil.findClass((String)"org.springframework.web.servlet.view.tiles3.TilesViewResolver", (DomElement)domElement) : null));
            if (psiClass == null) continue;
            for (ViewResolverFactory factory : (ViewResolverFactory[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                if (factory instanceof ViewResolversViewResolverFactory || !factory.isMine((CommonSpringBean)viewResolvers, psiClass)) continue;
                resolvers.addAll(factory.createResolvers((CommonSpringBean)viewResolvers, psiClass, model));
                continue block0;
            }
        }
        return resolvers;
    }

    @Nullable
    private static ViewResolver createBuiltinResolver(DomElement domElement, SpringModel model) {
        if (domElement instanceof ViewResolverBeanName) {
            return new BeanNameViewResolverFactory.BeanNameViewResolver();
        }
        if (!(domElement instanceof UrlViewResolverType)) {
            return null;
        }
        UrlViewResolverType urlViewResolverType = (UrlViewResolverType)domElement;
        if (domElement instanceof ViewResolverJsp) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.UrlBasedViewResolver", model, "/WEB-INF/", ".jsp");
        }
        if (domElement instanceof ViewResolverVelocity) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.velocity.VelocityViewResolver", model, "", ".vm");
        }
        if (domElement instanceof ViewResolverFreeMarker) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver", model, "", ".ftl");
        }
        if (domElement instanceof ViewResolverGroovy) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.UrlBasedViewResolver", model, "", ".tpl");
        }
        return null;
    }

    @Nullable
    private static ViewResolver createUrlBasedViewResolver(UrlViewResolverType urlViewResolverType, String viewClass, SpringModel model, String defaultPrefix, String defaultSuffix) {
        PsiClass psiClass = DomJavaUtil.findClass((String)viewClass, (DomElement)urlViewResolverType);
        if (psiClass == null) {
            return null;
        }
        for (ViewResolverFactory factory : ViewResolverRegistry.getInstance().getAllFactories()) {
            for (ViewResolver resolver : factory.createResolvers(null, psiClass, model)) {
                if (!(resolver instanceof UrlBasedViewResolver)) continue;
                String prefix = StringUtil.defaultIfEmpty((String)urlViewResolverType.getPrefix().getStringValue(), (String)defaultPrefix);
                String suffix = StringUtil.defaultIfEmpty((String)urlViewResolverType.getSuffix().getStringValue(), (String)defaultSuffix);
                return new UrlBasedViewResolver(StringUtil.defaultIfEmpty((String)((UrlBasedViewResolver)resolver).myPrefix, (String)prefix), StringUtil.defaultIfEmpty((String)((UrlBasedViewResolver)resolver).mySuffix, (String)suffix));
            }
        }
        throw new IllegalArgumentException("no registered resolver for " + viewClass + " and " + urlViewResolverType);
    }
}

