/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.parser.CSSOMParser;
import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.dombl.QuerySelectorImpl;
import org.lobobrowser.html.dombl.UINode;
import org.lobobrowser.html.domimpl.DOMElementImpl;
import org.lobobrowser.html.domimpl.DOMTokenListImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.renderstate.ColorRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.CSS2PropertiesContext;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.LocalCSS2Properties;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.w3c.DOMSettableTokenList;
import org.lobobrowser.html.w3c.DOMStringMap;
import org.lobobrowser.html.w3c.DOMTokenList;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.HTMLPropertiesCollection;
import org.lobobrowser.util.Strings;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class HTMLElementImpl
extends DOMElementImpl
implements HTMLElement,
CSS2PropertiesContext {
    private volatile AbstractCSS2Properties currentStyleDeclarationState;
    private volatile AbstractCSS2Properties localStyleDeclarationState;
    private Map<String, AbstractCSS2Properties> computedStyles;
    private boolean isMouseOver = false;
    private Boolean isHoverStyle = null;
    private Map<HTMLElementImpl, Boolean> hasHoverStyleByElement = null;

    public HTMLElementImpl(String name, boolean noStyleSheet) {
        super(name);
    }

    public HTMLElementImpl(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetLocalStyle() {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.currentStyleDeclarationState = null;
            this.localStyleDeclarationState = null;
            this.computedStyles = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetStyle(boolean deep) {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ArrayList nl;
            this.currentStyleDeclarationState = null;
            this.computedStyles = null;
            this.isHoverStyle = null;
            this.hasHoverStyleByElement = null;
            if (deep && (nl = this.nodeList) != null) {
                for (Object node : nl) {
                    if (!(node instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)node).forgetStyle(deep);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getCurrentStyle() {
        AbstractCSS2Properties sds;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            sds = this.currentStyleDeclarationState;
            if (sds != null) {
                return sds;
            }
        }
        sds = this.createDefaultStyleSheet();
        sds = this.addStyleSheetDeclarations(sds, this.getPseudoNames());
        AbstractCSS2Properties localStyle = this.getStyle();
        if (sds == null) {
            sds = new ComputedCSS2Properties(this);
            sds.setLocalStyleProperties(localStyle);
        } else {
            sds.setLocalStyleProperties(localStyle);
        }
        HTMLElementImpl hTMLElementImpl2 = this;
        synchronized (hTMLElementImpl2) {
            AbstractCSS2Properties setProps = this.currentStyleDeclarationState;
            if (setProps != null) {
                return setProps;
            }
            this.currentStyleDeclarationState = sds;
            return sds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getStyle() {
        AbstractCSS2Properties sds;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            sds = this.localStyleDeclarationState;
            if (sds != null) {
                return sds;
            }
            sds = new LocalCSS2Properties(this);
            String style = this.getAttribute("style");
            if (style != null && style.length() != 0) {
                CSSOMParser parser = new CSSOMParser();
                InputSource inputSource = this.getCssInputSourceForDecl(style);
                try {
                    CSSStyleDeclaration sd = parser.parseStyleDeclaration(inputSource);
                    sd.setCssText(style);
                    sds.addStyleDeclaration(sd);
                }
                catch (Exception err) {
                    String id = this.getId();
                    String withId = id == null ? "" : " with ID '" + id + "'";
                    this.warn("Unable to parse style attribute value for element " + this.getTagName() + withId + " in " + this.getDocumentURL() + ".", err);
                }
            }
            this.localStyleDeclarationState = sds;
        }
        return sds;
    }

    protected AbstractCSS2Properties createDefaultStyleSheet() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getComputedStyle(String pseudoElement) {
        if (pseudoElement == null) {
            pseudoElement = "";
        }
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            AbstractCSS2Properties sds;
            Map<String, AbstractCSS2Properties> cs = this.computedStyles;
            if (cs != null && (sds = cs.get(pseudoElement)) != null) {
                return sds;
            }
        }
        Set<String> pes = pseudoElement.length() == 0 ? null : Collections.singleton(pseudoElement);
        AbstractCSS2Properties sds = this.createDefaultStyleSheet();
        sds = this.addStyleSheetDeclarations(sds, pes);
        AbstractCSS2Properties localStyle = this.getStyle();
        if (sds == null) {
            sds = new ComputedCSS2Properties(this);
            sds.setLocalStyleProperties(localStyle);
        } else {
            sds.setLocalStyleProperties(localStyle);
        }
        HTMLElementImpl hTMLElementImpl2 = this;
        synchronized (hTMLElementImpl2) {
            Map<String, AbstractCSS2Properties> cs = this.computedStyles;
            if (cs == null) {
                this.computedStyles = cs = new HashMap<String, AbstractCSS2Properties>(2);
            } else {
                AbstractCSS2Properties sds2 = cs.get(pseudoElement);
                if (sds2 != null) {
                    return sds2;
                }
            }
            cs.put(pseudoElement, sds);
        }
        return sds;
    }

    public void setStyle(String value) {
        this.setAttribute("style", value);
    }

    @Override
    public String getClassName() {
        String className = this.getAttribute("class");
        return className == null ? "" : className;
    }

    @Override
    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    public String getCharset() {
        return this.getAttribute("charset");
    }

    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    @Override
    public void warn(String message, Throwable err) {
        logger.log(Level.WARNING, message, err);
    }

    @Override
    public void warn(String message) {
        logger.log(Level.WARNING, message);
    }

    protected int getAttributeAsInt(String name, int defaultValue) {
        String value = this.getAttribute(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception err) {
            this.warn("Bad integer", err);
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    protected void assignAttributeField(String normalName, String value) {
        if (!this.notificationsSuspended) {
            this.informInvalidAttibute(normalName);
        } else if ("style".equals(normalName)) {
            this.forgetLocalStyle();
        }
        super.assignAttributeField(normalName, value);
    }

    protected final InputSource getCssInputSourceForDecl(String text) {
        StringReader reader = new StringReader("{" + text + "}");
        InputSource is = new InputSource(reader);
        return is;
    }

    protected final AbstractCSS2Properties addStyleSheetDeclarations(AbstractCSS2Properties style, Set<String> pseudoNames) {
        block7: {
            block6: {
                Node pn = this.parentNode;
                if (pn == null) {
                    return style;
                }
                String classNames = this.getClassName();
                if (classNames == null || classNames.length() == 0) break block6;
                String id = this.getId();
                String elementName = this.getTagName();
                String[] classNameArray = Strings.split(classNames);
                int i = classNameArray.length;
                while (--i >= 0) {
                    String className = classNameArray[i];
                    Collection<CSSStyleDeclaration> sds = this.findStyleDeclarations(elementName, id, className, pseudoNames);
                    if (sds == null) continue;
                    for (CSSStyleDeclaration sd : sds) {
                        if (style == null) {
                            style = new ComputedCSS2Properties(this);
                        }
                        style.addStyleDeclaration(sd);
                    }
                }
                break block7;
            }
            String id = this.getId();
            String elementName = this.getTagName();
            Collection<CSSStyleDeclaration> sds = this.findStyleDeclarations(elementName, id, null, pseudoNames);
            if (sds == null) break block7;
            for (CSSStyleDeclaration sd : sds) {
                if (style == null) {
                    style = new ComputedCSS2Properties(this);
                }
                style.addStyleDeclaration(sd);
            }
        }
        return style;
    }

    public void setMouseOver(boolean mouseOver) {
        if (this.isMouseOver != mouseOver) {
            this.isMouseOver = mouseOver;
            this.invalidateDescendentsForHover();
            if (this.hasHoverStyle()) {
                this.informInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateDescendentsForHover() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.invalidateDescendentsForHoverImpl(this);
        }
    }

    private void invalidateDescendentsForHoverImpl(HTMLElementImpl ancestor) {
        ArrayList nodeList = this.nodeList;
        if (nodeList != null) {
            int size = nodeList.size();
            for (int i = 0; i < size; ++i) {
                Object node = nodeList.get(i);
                if (!(node instanceof HTMLElementImpl)) continue;
                HTMLElementImpl descendent = (HTMLElementImpl)node;
                if (descendent.hasHoverStyle(ancestor)) {
                    descendent.informInvalid();
                }
                descendent.invalidateDescendentsForHoverImpl(ancestor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasHoverStyle() {
        Boolean ihs;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ihs = this.isHoverStyle;
            if (ihs != null) {
                return ihs;
            }
        }
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc == null) {
            ihs = Boolean.FALSE;
        } else {
            StyleSheetAggregator ssa = doc.getStyleSheetAggregator();
            String id = this.getId();
            String elementName = this.getTagName();
            String classNames = this.getClassName();
            String[] classNameArray = null;
            if (classNames != null && classNames.length() != 0) {
                classNameArray = Strings.split(classNames);
            }
            ihs = ssa.affectedByPseudoNameInAncestor(this, this, elementName, id, classNameArray, "hover");
        }
        HTMLElementImpl hTMLElementImpl2 = this;
        synchronized (hTMLElementImpl2) {
            this.isHoverStyle = ihs;
        }
        return ihs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasHoverStyle(HTMLElementImpl ancestor) {
        Boolean hhs;
        Map<HTMLElementImpl, Boolean> ihs;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            Boolean f;
            ihs = this.hasHoverStyleByElement;
            if (ihs != null && (f = ihs.get(ancestor)) != null) {
                return f;
            }
        }
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc == null) {
            hhs = Boolean.FALSE;
        } else {
            StyleSheetAggregator ssa = doc.getStyleSheetAggregator();
            String id = this.getId();
            String elementName = this.getTagName();
            String classNames = this.getClassName();
            String[] classNameArray = null;
            if (classNames != null && classNames.length() != 0) {
                classNameArray = Strings.split(classNames);
            }
            hhs = ssa.affectedByPseudoNameInAncestor(this, ancestor, elementName, id, classNameArray, "hover");
        }
        HTMLElementImpl hTMLElementImpl2 = this;
        synchronized (hTMLElementImpl2) {
            ihs = this.hasHoverStyleByElement;
            if (ihs == null) {
                this.hasHoverStyleByElement = ihs = new HashMap<HTMLElementImpl, Boolean>(2);
            }
            ihs.put(ancestor, hhs);
        }
        return hhs;
    }

    public Set<String> getPseudoNames() {
        HashSet<String> pnset = null;
        if (this.isMouseOver) {
            if (pnset == null) {
                pnset = new HashSet<String>(1);
            }
            pnset.add("hover");
        }
        return pnset;
    }

    protected final Collection<CSSStyleDeclaration> findStyleDeclarations(String elementName, String id, String className, Set<String> pseudoNames) {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc == null) {
            return null;
        }
        StyleSheetAggregator ssa = doc.getStyleSheetAggregator();
        return ssa.getActiveStyleDeclarations(this, elementName, id, className, pseudoNames);
    }

    @Override
    public void informInvalid() {
        this.forgetStyle(false);
        super.informInvalid();
    }

    public void informInvalidAttibute(String normalName) {
        if ("style".equals(normalName)) {
            this.forgetLocalStyle();
        } else if ("id".equals(normalName) || "class".equals(normalName)) {
            this.forgetStyle(false);
        }
        super.informInvalid();
    }

    protected FormInput[] getFormInputs() {
        return null;
    }

    private boolean classMatch(String classTL) {
        String classNames = this.getClassName();
        if (classNames == null || classNames.length() == 0) {
            return classTL == null;
        }
        StringTokenizer tok = new StringTokenizer(classNames, " \t\r\n");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!token.toLowerCase().equals(classTL)) continue;
            return true;
        }
        return false;
    }

    public HTMLElementImpl getAncestorWithClass(String elementTL, String classTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && parentElement.classMatch(classTL)) {
                return parentElement;
            }
            return parentElement.getAncestorWithClass(elementTL, classTL);
        }
        return null;
    }

    public HTMLElementImpl getParentWithClass(String elementTL, String classTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && parentElement.classMatch(classTL)) {
                return parentElement;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingElement() {
        Node parentNode = this.getParentNode();
        if (parentNode == null) {
            return null;
        }
        NodeList childNodes = parentNode.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        int length = childNodes.getLength();
        HTMLElementImpl priorElement = null;
        for (int i = 0; i < length; ++i) {
            Node child = childNodes.item(i);
            if (child == this) {
                return priorElement;
            }
            if (!(child instanceof HTMLElementImpl)) continue;
            priorElement = (HTMLElementImpl)child;
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingWithClass(String elementTL, String classTL) {
        HTMLElementImpl psibling = this.getPreceedingSiblingElement();
        if (psibling != null) {
            String pelementTL = psibling.getTagName().toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && psibling.classMatch(classTL)) {
                return psibling;
            }
        }
        return null;
    }

    public HTMLElementImpl getAncestorWithId(String elementTL, String idTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            String pidTL;
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            String pid = parentElement.getId();
            String string = pidTL = pid == null ? null : pid.toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && idTL.equals(pidTL)) {
                return parentElement;
            }
            return parentElement.getAncestorWithId(elementTL, idTL);
        }
        return null;
    }

    public HTMLElementImpl getParentWithId(String elementTL, String idTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            String pidTL;
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            String pelementTL = parentElement.getTagName().toLowerCase();
            String pid = parentElement.getId();
            String string = pidTL = pid == null ? null : pid.toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && idTL.equals(pidTL)) {
                return parentElement;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingWithId(String elementTL, String idTL) {
        HTMLElementImpl psibling = this.getPreceedingSiblingElement();
        if (psibling != null) {
            String pidTL;
            String pelementTL = psibling.getTagName().toLowerCase();
            String pid = psibling.getId();
            String string = pidTL = pid == null ? null : pid.toLowerCase();
            if (("*".equals(elementTL) || elementTL.equals(pelementTL)) && idTL.equals(pidTL)) {
                return psibling;
            }
        }
        return null;
    }

    public HTMLElementImpl getAncestor(String elementTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            if ("*".equals(elementTL)) {
                return parentElement;
            }
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (elementTL.equals(pelementTL)) {
                return parentElement;
            }
            return parentElement.getAncestor(elementTL);
        }
        return null;
    }

    public HTMLElementImpl getParent(String elementTL) {
        Node nodeObj = this.getParentNode();
        if (nodeObj instanceof HTMLElementImpl) {
            HTMLElementImpl parentElement = (HTMLElementImpl)nodeObj;
            if ("*".equals(elementTL)) {
                return parentElement;
            }
            String pelementTL = parentElement.getTagName().toLowerCase();
            if (elementTL.equals(pelementTL)) {
                return parentElement;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSibling(String elementTL) {
        HTMLElementImpl psibling = this.getPreceedingSiblingElement();
        if (psibling != null) {
            if ("*".equals(elementTL)) {
                return psibling;
            }
            String pelementTL = psibling.getTagName().toLowerCase();
            if (elementTL.equals(pelementTL)) {
                return psibling;
            }
        }
        return null;
    }

    protected Object getAncestorForJavaClass(Class javaClass) {
        Node nodeObj = this.getParentNode();
        if (nodeObj == null || javaClass.isInstance(nodeObj)) {
            return nodeObj;
        }
        if (nodeObj instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)nodeObj).getAncestorForJavaClass(javaClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInnerHTML(String newHtml) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document == null) {
            this.warn("setInnerHTML(): Element " + this + " does not belong to a document.");
            return;
        }
        HtmlParser parser = new HtmlParser(document.getUserAgentContext(), document, null, null, null);
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                nl.clear();
            }
        }
        try {
            StringReader reader = new StringReader(newHtml);
            try {
                parser.parse(reader, (Node)this);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Exception thrown) {
            this.warn("setInnerHTML(): Error setting inner HTML.", thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOuterHTML() {
        StringBuffer buffer = new StringBuffer();
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.appendOuterHTMLImpl(buffer);
        }
        return buffer.toString();
    }

    public void appendOuterHTMLImpl(StringBuffer buffer) {
        ArrayList nl;
        String tagName = this.getTagName();
        buffer.append('<');
        buffer.append(tagName);
        Map attributes = this.attributes;
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                buffer.append(' ');
                buffer.append(entry.getKey());
                buffer.append("=\"");
                buffer.append(Strings.strictHtmlEncode(value, true));
                buffer.append("\"");
            }
        }
        if ((nl = this.nodeList) == null || nl.size() == 0) {
            buffer.append("/>");
            return;
        }
        buffer.append('>');
        this.appendInnerHTMLImpl(buffer);
        buffer.append("</");
        buffer.append(tagName);
        buffer.append('>');
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        if (prevRenderState.getColor() == null) {
            prevRenderState = new ColorRenderState(prevRenderState, Color.BLACK);
        }
        return new StyleSheetRenderState(prevRenderState, this);
    }

    @Override
    public int getOffsetTop() {
        UINode uiNode = this.getUINode();
        return uiNode == null ? 0 : uiNode.getBoundsRelativeToBlock().y;
    }

    @Override
    public int getOffsetLeft() {
        UINode uiNode = this.getUINode();
        return uiNode == null ? 0 : uiNode.getBoundsRelativeToBlock().x;
    }

    @Override
    public int getOffsetWidth() {
        UINode uiNode = this.getUINode();
        return uiNode == null ? 0 : uiNode.getBoundsRelativeToBlock().width;
    }

    @Override
    public int getOffsetHeight() {
        UINode uiNode = this.getUINode();
        return uiNode == null ? 0 : uiNode.getBoundsRelativeToBlock().height;
    }

    @Override
    public AbstractCSS2Properties getParentStyle() {
        Node parent = this.parentNode;
        if (parent instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)parent).getCurrentStyle();
        }
        return null;
    }

    @Override
    public String getDocumentBaseURI() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            return doc.getBaseURI();
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "[currentStyle=" + this.getCurrentStyle() + "]";
    }

    @Override
    public void setOuterHTML(String outerHTML) {
    }

    @Override
    public void insertAdjacentHTML(String position, String text) {
    }

    @Override
    public DOMTokenList getClassList() {
        return new DOMTokenListImpl(this, this.getClassName());
    }

    @Override
    public DOMStringMap getDataset() {
        return null;
    }

    @Override
    public void click() {
    }

    @Override
    public void scrollIntoView(boolean top) {
    }

    @Override
    public void focus() {
    }

    @Override
    public void blur() {
    }

    @Override
    public String getAccessKeyLabel() {
        return null;
    }

    @Override
    public String getCommandType() {
        return null;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public Element getOffsetParent() {
        return null;
    }

    @Override
    public DOMSettableTokenList getItemRef() {
        return null;
    }

    @Override
    public void setItemRef(String itemRef) {
    }

    @Override
    public DOMSettableTokenList getItemProp() {
        return null;
    }

    @Override
    public void setItemProp(String itemProp) {
    }

    @Override
    public HTMLPropertiesCollection getProperties() {
        return null;
    }

    @Override
    public Object getItemValue() {
        return null;
    }

    @Override
    public void setItemValue(Object itemValue) {
    }

    @Override
    public Element querySelector(String selectors) {
        QuerySelectorImpl qsel = new QuerySelectorImpl();
        return qsel.documentQuerySelector(this.document, selectors);
    }

    @Override
    public NodeList querySelectorAll(String selectors) {
        QuerySelectorImpl qsel = new QuerySelectorImpl();
        return qsel.documentQuerySelectorAll(this.document, selectors);
    }
}

