/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;

public class IFrameRenderState
extends StyleSheetRenderState {
    public IFrameRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    @Override
    public int getOverflowX() {
        String scrolling;
        HTMLElementImpl element;
        int overflow = this.overflowX;
        if (overflow != -1) {
            return overflow;
        }
        overflow = super.getOverflowX();
        if (overflow == 0 && (element = this.element) != null && (scrolling = element.getAttribute("scrolling")) != null) {
            if ("no".equals(scrolling = scrolling.trim().toLowerCase())) {
                overflow = 3;
            } else if ("yes".equals(scrolling)) {
                overflow = 1;
            } else if ("auto".equals(scrolling)) {
                overflow = 2;
            }
        }
        this.overflowX = overflow;
        return overflow;
    }

    @Override
    public int getOverflowY() {
        String scrolling;
        HTMLElementImpl element;
        int overflow = this.overflowY;
        if (overflow != -1) {
            return overflow;
        }
        overflow = super.getOverflowY();
        if (overflow == 0 && (element = this.element) != null && (scrolling = element.getAttribute("scrolling")) != null) {
            if ("no".equals(scrolling = scrolling.trim().toLowerCase())) {
                overflow = 3;
            } else if ("yes".equals(scrolling)) {
                overflow = 1;
            } else if ("auto".equals(scrolling)) {
                overflow = 2;
            }
        }
        this.overflowY = overflow;
        return overflow;
    }

    @Override
    public BorderInfo getBorderInfo() {
        BorderInfo binfo = this.borderInfo;
        if (binfo != INVALID_BORDER_INFO) {
            return binfo;
        }
        binfo = super.getBorderInfo();
        if (binfo == null || binfo.getTopStyle() == 0 && binfo.getBottomStyle() == 0 && binfo.getLeftStyle() == 0 && binfo.getRightStyle() == 0) {
            HTMLElementImpl element;
            if (binfo == null) {
                binfo = new BorderInfo();
            }
            if ((element = this.element) != null) {
                int value;
                String border = element.getAttribute("frameBorder");
                if (border != null) {
                    border = border.trim();
                }
                if (border != null) {
                    try {
                        value = Integer.parseInt(border);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                } else {
                    value = 1;
                }
                HtmlInsets borderInsets = new HtmlInsets();
                borderInsets.bottom = value != 0 ? 1 : 0;
                borderInsets.right = borderInsets.bottom;
                borderInsets.left = borderInsets.bottom;
                borderInsets.top = borderInsets.bottom;
                borderInsets.bottomType = 1;
                borderInsets.rightType = 1;
                borderInsets.leftType = 1;
                borderInsets.topType = 1;
                binfo.setInsets(borderInsets);
                if (binfo.getTopColor() == null) {
                    binfo.setTopColor(Color.DARK_GRAY);
                }
                if (binfo.getLeftColor() == null) {
                    binfo.setLeftColor(Color.DARK_GRAY);
                }
                if (binfo.getRightColor() == null) {
                    binfo.setRightColor(Color.LIGHT_GRAY);
                }
                if (binfo.getBottomColor() == null) {
                    binfo.setBottomColor(Color.LIGHT_GRAY);
                }
                if (value != 0) {
                    binfo.setTopStyle(4);
                    binfo.setLeftStyle(4);
                    binfo.setRightStyle(4);
                    binfo.setBottomStyle(4);
                }
            }
        }
        this.borderInfo = binfo;
        return binfo;
    }
}

