/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.util.gui.ColorFactory;

public class TableRenderState
extends StyleSheetRenderState {
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;

    public TableRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    @Override
    public Color getTextBackgroundColor() {
        return super.getTextBackgroundColor();
    }

    @Override
    protected int getDefaultDisplay() {
        return 6;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
    }

    @Override
    public BackgroundInfo getBackgroundInfo() {
        String background;
        String bgColor;
        BackgroundInfo binfo = this.backgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        HTMLTableElementImpl element = (HTMLTableElementImpl)this.element;
        if (!(binfo != null && binfo.backgroundColor != null || (bgColor = element.getBgColor()) == null || "".equals(bgColor))) {
            Color bgc = ColorFactory.getInstance().getColor(bgColor);
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundColor = bgc;
        }
        if (!(binfo != null && binfo.backgroundImage != null || (background = element.getAttribute("background")) == null || "".equals(background))) {
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundImage = this.document.getFullURL(background);
        }
        this.backgroundInfo = binfo;
        return binfo;
    }

    @Override
    public BorderInfo getBorderInfo() {
        BorderInfo binfo = this.borderInfo;
        if (binfo != INVALID_BORDER_INFO) {
            return binfo;
        }
        binfo = super.getBorderInfo();
        if (binfo == null || binfo.getTopStyle() == 0 && binfo.getBottomStyle() == 0 && binfo.getLeftStyle() == 0 && binfo.getRightStyle() == 0) {
            String border;
            HTMLElementImpl element;
            if (binfo == null) {
                binfo = new BorderInfo();
            }
            if ((element = this.element) != null && (border = element.getAttribute("border")) != null) {
                int value;
                int valueType;
                if ((border = border.trim()).endsWith("%")) {
                    valueType = 3;
                    try {
                        value = Integer.parseInt(border.substring(0, border.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                } else {
                    valueType = 1;
                    try {
                        value = Integer.parseInt(border);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                }
                HtmlInsets borderInsets = new HtmlInsets();
                borderInsets.right = borderInsets.bottom = value;
                borderInsets.left = borderInsets.bottom;
                borderInsets.top = borderInsets.bottom;
                borderInsets.rightType = borderInsets.bottomType = valueType;
                borderInsets.leftType = borderInsets.bottomType;
                borderInsets.topType = borderInsets.bottomType;
                binfo.setInsets(borderInsets);
                if (binfo.getTopColor() == null) {
                    binfo.setTopColor(Color.LIGHT_GRAY);
                }
                if (binfo.getLeftColor() == null) {
                    binfo.setLeftColor(Color.LIGHT_GRAY);
                }
                if (binfo.getRightColor() == null) {
                    binfo.setRightColor(Color.GRAY);
                }
                if (binfo.getBottomColor() == null) {
                    binfo.setBottomColor(Color.GRAY);
                }
                if (value != 0) {
                    binfo.setTopStyle(4);
                    binfo.setLeftStyle(4);
                    binfo.setRightStyle(4);
                    binfo.setBottomStyle(4);
                }
            }
        }
        this.borderInfo = binfo;
        return binfo;
    }
}

