/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.Component;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.w3c.HTMLDocument;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.util.io.BufferExceededException;
import org.lobobrowser.util.io.RecordedInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlContent
implements ComponentContent {
    private static final Logger logger = Logger.getLogger(HtmlContent.class.getName());
    private final HTMLDocument document;
    private final HtmlPanel panel;
    private final RecordedInputStream ris;
    private final String charset;
    private final String sourceCode;

    public HtmlContent(HTMLDocument document, HtmlPanel panel, RecordedInputStream ris, String charset) {
        this.document = document;
        this.panel = panel;
        this.ris = ris;
        this.charset = charset;
        this.sourceCode = null;
    }

    public HtmlContent(HTMLDocument document, HtmlPanel panel, String sourceCode) {
        this.document = document;
        this.panel = panel;
        this.ris = null;
        this.charset = null;
        this.sourceCode = sourceCode;
    }

    @Override
    public boolean canCopy() {
        return this.panel.hasSelection();
    }

    @Override
    public boolean copy() {
        return this.panel.copy();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getSourceCode() {
        try {
            RecordedInputStream ris = this.ris;
            if (ris != null) {
                byte[] bytesSoFar = ris.getBytesRead();
                try {
                    return new String(bytesSoFar, this.charset);
                }
                catch (UnsupportedEncodingException uee) {
                    return "[Error: " + uee + "]";
                }
            }
            return this.sourceCode;
        }
        catch (BufferExceededException bee) {
            return "[Error: Document content too large.]";
        }
    }

    @Override
    public String getTitle() {
        return this.document.getTitle();
    }

    @Override
    public String getDescription() {
        NodeList nodeList = this.document.getElementsByTagName("meta");
        if (nodeList == null) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            HTMLElement element;
            String name;
            Node node = nodeList.item(i);
            if (!(node instanceof HTMLElement) || (name = (element = (HTMLElement)node).getAttribute("name")) == null || !name.equalsIgnoreCase("description")) continue;
            return element.getAttribute("description");
        }
        return null;
    }

    @Override
    public void addNotify() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public Object getContentObject() {
        return this.document;
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("defaultMarginInsets".equals(name) && value instanceof Insets) {
            this.panel.setDefaultMarginInsets((Insets)value);
        } else if ("defaultOverflowX".equals(name) && value instanceof Integer) {
            this.panel.setDefaultOverflowX((Integer)value);
        } else if ("defaultOverflowY".equals(name) && value instanceof Integer) {
            this.panel.setDefaultOverflowY((Integer)value);
        } else if (logger.isLoggable(Level.INFO)) {
            logger.info("setProperty(): Unknown property: " + name);
        }
    }
}

