/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jsf.generation.EntityGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplatesFactory;
import com.intellij.jsf.generation.GenerateSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class FacesGenerationTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.jsf.generation.FacesGenerationTemplateUtil");
    private static final String ENTITY_INFO = "entityInfo";
    private static final String EDIT_ACTION = "EDIT_ACTION";
    private static final String LIST_ACTION = "LIST_ACTION";
    private static final String VIEW_ACTION = "VIEW_ACTION";
    private static final String CREATE_ACTION = "CREATE_ACTION";
    private static final String PERSISTENCE_UNIT_NAME = "PERSISTENCE_UNIT_NAME";
    private static final String MANAGED_BEAN_CLASS_NAME = "MANAGED_BEAN_CLASS_NAME";
    private static final String CONVERTER_CLASS_NAME = "CONVERTER_CLASS_NAME";

    public static List<String> getEditTemplates() {
        return Arrays.asList(FacesGenerationTemplatesFactory.EDIT_TEMPLATES);
    }

    public static List<String> getCretaeTemplates() {
        return Arrays.asList(FacesGenerationTemplatesFactory.CREATE_TEMPLATES);
    }

    public static List<String> getViewTemplates() {
        return Arrays.asList(FacesGenerationTemplatesFactory.VIEW_TEMPLATES);
    }

    public static List<String> getListTemplates() {
        return Arrays.asList(FacesGenerationTemplatesFactory.LIST_TEMPLATES);
    }

    public static List<String> getManagedBeantTemplates() {
        return Arrays.asList(FacesGenerationTemplatesFactory.MANAGED_BEAN_TEMPLATES);
    }

    public static String getDefaultEditTemplate() {
        return "generate_edit.jsp";
    }

    public static String getDefaultCreateTemplate() {
        return "generate_create.jsp";
    }

    public static String getDefaultViewTemplate() {
        return "generate_view.jsp";
    }

    public static String getDefaultListTemplate() {
        return "generate_table.jsp";
    }

    public static String getDefaultManagedBeanTemplate() {
        return "managed_bean_template1.java";
    }

    public static String createTemplateText(EntityGenerateInfo generateInfo, GenerateSettings settings, String template) {
        return FacesGenerationTemplateUtil.createTemplateText(template, FacesGenerationTemplateUtil.getDefaultGenerateProperties(generateInfo, settings));
    }

    public static String createTemplateText(String template, HashMap<String, Object> hashMap) {
        String text = "";
        try {
            text = FacesGenerationTemplatesFactory.getTemplate(template).getText(hashMap);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text;
    }

    public static HashMap<String, Object> getDefaultGenerateProperties(EntityGenerateInfo generateInfo, GenerateSettings settings) {
        Properties properties = FileTemplateManager.getInstance((Project)generateInfo.getModule().getProject()).getDefaultProperties();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            String s = (String)key;
            hashMap.put(s, properties.getProperty(s));
        }
        hashMap.put(ENTITY_INFO, generateInfo);
        hashMap.put(PERSISTENCE_UNIT_NAME, settings.getPersistenceUnitName());
        hashMap.put(EDIT_ACTION, settings.getEditAction());
        hashMap.put(LIST_ACTION, settings.getListAction());
        hashMap.put(VIEW_ACTION, settings.getViewAction());
        hashMap.put(CREATE_ACTION, settings.getCreateAction());
        PsiPackage aPackage = settings.getManagedBeanPackage();
        if (aPackage != null) {
            String packageName = aPackage.getName();
            hashMap.put("PACKAGE_NAME", packageName == null ? "" : packageName);
        }
        String managedBeanClassName = FacesGenerationTemplateUtil.getManagedBeanClassName(generateInfo, settings);
        hashMap.put("CLASS_NAME", managedBeanClassName);
        hashMap.put(MANAGED_BEAN_CLASS_NAME, managedBeanClassName);
        hashMap.put(CONVERTER_CLASS_NAME, FacesGenerationTemplateUtil.getConverterClassName(generateInfo, settings));
        return hashMap;
    }

    public static String getManagedBeanName(String entityName) {
        return StringUtil.decapitalize((String)entityName);
    }

    public static String getManagedBeanClassName(EntityGenerateInfo generateInfo, GenerateSettings settings) {
        return generateInfo.getName() + settings.getManagedBeanSuffix();
    }

    public static String getConverterClassName(EntityGenerateInfo generateInfo, GenerateSettings settings) {
        return generateInfo.getName() + "Converter";
    }
}

