/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.html5.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PassThroughIdPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/html5/references/PassThroughIdPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/html5/references/PassThroughIdPsiReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new IdRefReference(element){

            @NotNull
            public Object[] getVariants() {
                XmlAttribute attribute = (XmlAttribute)this.getElement().getParent();
                if (attribute != null && attribute.getName().endsWith("id")) {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/html5/references/PassThroughIdPsiReferenceProvider$1", "getVariants"));
                    }
                    return EMPTY_ARRAY;
                }
                Object[] objectArray = super.getVariants();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/html5/references/PassThroughIdPsiReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }

            public boolean isSoft() {
                return false;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/html5/references/PassThroughIdPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public ElementFilter getPassThroughIdForFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlAttribute parent;
                PsiElement grandParent = ((PsiElement)element).getParent();
                return grandParent instanceof XmlAttribute && "http://xmlns.jcp.org/jsf".equals((parent = (XmlAttribute)grandParent).getNamespace());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }
}

