/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.MethodPropertyReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.XmlValueReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfXmlTagReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String PROPERTY_NAME_TAG_NAME = "property-name";
    @NonNls
    private static final String MANAGED_BEAN_NAME_TAG_NAME = "managed-bean-name";
    @NonNls
    private static final String PROPERTY_CLASS_TAG_NAME = "property-class";

    public String[] getTagNames() {
        return new String[]{PROPERTY_NAME_TAG_NAME, PROPERTY_CLASS_TAG_NAME, MANAGED_BEAN_NAME_TAG_NAME};
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfXmlTagReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/references/JsfXmlTagReferencesProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlTag) {
            String localName = ((XmlTag)element).getLocalName();
            if (PROPERTY_NAME_TAG_NAME.equals(localName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JsfPropertyReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            if (PROPERTY_CLASS_TAG_NAME.equals(localName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JSFPropertyTypeReference((XmlTag)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    static class JsfPropertyReference
    extends MethodPropertyReference {
        private TextRange myRange;

        public JsfPropertyReference(PsiElement element) {
            super(element, false);
            this.myRange = ElementManipulators.getValueTextRange((PsiElement)((XmlTag)this.myElement));
        }

        protected PsiElement getClassReferencesElement() {
            PsiElement parent = this.myElement.getParent();
            if (parent == null) {
                return null;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof XmlTag)) {
                return null;
            }
            return ((XmlTag)grandParent).findFirstSubTag("managed-bean-class");
        }

        @Nullable
        public PsiElement resolve() {
            PsiElement psiElement = super.resolve();
            if (psiElement == null && this.resolveClass() == null) {
                return this.myElement;
            }
            return psiElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider$JsfPropertyReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String _newElementName) throws IncorrectOperationException {
            PsiElement psiElement = super.handleElementRename(_newElementName);
            this.myRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            return psiElement;
        }
    }

    static class JSFPropertyTypeReference
    extends XmlValueReference {
        protected JSFPropertyTypeReference(XmlTag tag) {
            super(tag);
        }

        @Nullable
        public PsiElement resolve() {
            String canonicalText = this.getCanonicalText();
            if (canonicalText.equals("int") || canonicalText.equals("double")) {
                return this.myTag;
            }
            String myMethodTypeString = JSFPropertyTypeReference.getMethodTypeString(this.getMyMethodType());
            if (myMethodTypeString != null && !canonicalText.equals(myMethodTypeString)) {
                return null;
            }
            return this.myTag;
        }

        private static String getMethodTypeString(PsiType myMethodType) {
            PsiClass psiClass;
            if (myMethodType == null) {
                return null;
            }
            if (myMethodType instanceof PsiClassType && (psiClass = ((PsiClassType)myMethodType).resolve()) != null) {
                return psiClass.getQualifiedName();
            }
            return myMethodType.getCanonicalText();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfXmlTagReferencesProvider$JSFPropertyTypeReference", "bindToElement"));
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            String myMethodTypeString = JSFPropertyTypeReference.getMethodTypeString(this.getMyMethodType());
            if (myMethodTypeString != null) {
                Object[] objectArray = new LookupElement[]{AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)myMethodTypeString))};
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider$JSFPropertyTypeReference", "getVariants"));
                }
                return objectArray;
            }
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfXmlTagReferencesProvider$JSFPropertyTypeReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }

        private PsiType getMyMethodType() {
            PsiElement parent = this.myTag.getParent();
            if (!(parent instanceof XmlTag)) {
                return null;
            }
            XmlTag firstSubTag = ((XmlTag)parent).findFirstSubTag(JsfXmlTagReferencesProvider.PROPERTY_NAME_TAG_NAME);
            if (firstSubTag == null) {
                return null;
            }
            PsiReference[] references = firstSubTag.getReferences();
            if (references.length > 2) {
                for (int i = 2; i < references.length; ++i) {
                    JsfPropertyReference propertyReference;
                    PsiElement psiElement;
                    PsiReference reference = references[i];
                    if (!(reference instanceof JsfPropertyReference) || !((psiElement = (propertyReference = (JsfPropertyReference)reference).resolve()) instanceof PsiMethod)) continue;
                    PsiParameter[] parameters = ((PsiMethod)psiElement).getParameterList().getParameters();
                    return parameters.length == 1 ? parameters[0].getType() : null;
                }
            }
            return null;
        }
    }
}

