/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoriesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.project.taskfactory.TaskPropertyValue;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskClassValidator
implements TaskValidator,
Action<Task> {
    private static final Collection<Class<?>> IGNORED_SUPER_CLASSES = ImmutableSet.of(ConventionTask.class, DefaultTask.class, AbstractTask.class, Task.class, Object.class, GroovyObject.class, (Object[])new Class[0]);
    private static final ValidationAction NOT_NULL_VALIDATOR = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            if (value == null) {
                messages.add(String.format("No value has been specified for property '%s'.", propertyName));
            }
        }
    };
    private static final List<? extends PropertyAnnotationHandler> HANDLERS = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(), new OutputFilesPropertyAnnotationHandler(), new OutputDirectoryPropertyAnnotationHandler(), new OutputDirectoriesPropertyAnnotationHandler(), new InputPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler(), new NoOpPropertyAnnotationHandler(Inject.class), new NoOpPropertyAnnotationHandler(Console.class), new NoOpPropertyAnnotationHandler(Internal.class), new NoOpPropertyAnnotationHandler(OptionValues.class));
    private final Set<TaskPropertyInfo> validatedProperties = Sets.newLinkedHashSet();
    private final Set<String> allPropertyNames = Sets.newTreeSet();
    private final Set<String> annotatedPropertyNames = Sets.newTreeSet();

    public void execute(Task task) {
    }

    public void addInputsAndOutputs(final TaskInternal task) {
        task.addValidator(this);
        for (final TaskPropertyInfo property : this.validatedProperties) {
            Callable<Object> futureValue = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return property.getValue(task).getValue();
                }
            };
            property.getConfigureAction().update(task, futureValue);
        }
    }

    @Override
    public void validate(TaskInternal task, Collection<String> messages) {
        ArrayList<TaskPropertyValue> propertyValues = new ArrayList<TaskPropertyValue>();
        for (TaskPropertyInfo property : this.validatedProperties) {
            propertyValues.add(property.getValue(task));
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkNotNull(messages);
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkValid(messages);
        }
    }

    public <T> void attachActions(final TaskPropertyInfo parent, Class<T> type) {
        final HashMap properties = Maps.newHashMap();
        Types.walkTypeHierarchy(type, IGNORED_SUPER_CLASSES, (Types.TypeVisitor)new Types.TypeVisitor<T>(){

            public void visitType(Class<? super T> type) {
                Map fields = TaskClassValidator.this.getFields(type);
                for (Method method : type.getDeclaredMethods()) {
                    PropertyAccessorType accessorType = PropertyAccessorType.of((Method)method);
                    if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || GroovyMethods.isObjectMethod((Method)method)) continue;
                    String fieldName = accessorType.propertyNameFor(method);
                    Field field = (Field)fields.get(fieldName);
                    String propertyName = parent != null ? parent.getName() + '.' + fieldName : fieldName;
                    TaskPropertyInfo propertyInfo = (TaskPropertyInfo)properties.get(propertyName);
                    if (propertyInfo == null) {
                        propertyInfo = new TaskPropertyInfo(TaskClassValidator.this, parent, propertyName, method, field);
                        properties.put(propertyName, propertyInfo);
                    } else if (propertyInfo.getInstanceVariableField() == null && field != null) {
                        propertyInfo.setInstanceVariableField(field);
                    }
                    propertyInfo.addAnnotations(method.getDeclaredAnnotations());
                    if (field == null) continue;
                    propertyInfo.addAnnotations(field.getDeclaredAnnotations());
                }
            }
        });
        for (TaskPropertyInfo propertyInfo : properties.values()) {
            boolean annotationFound = this.attachValidationActions(propertyInfo);
            if (propertyInfo.isValidationRequired()) {
                this.validatedProperties.add(propertyInfo);
            }
            String propertyName = propertyInfo.getName();
            this.allPropertyNames.add(propertyName);
            if (!annotationFound) continue;
            this.annotatedPropertyNames.add(propertyName);
        }
    }

    public boolean hasAnythingToValidate() {
        return !this.validatedProperties.isEmpty();
    }

    public Set<TaskPropertyInfo> getValidatedProperties() {
        return this.validatedProperties;
    }

    public Set<String> getNonAnnotatedPropertyNames() {
        return Sets.difference(this.allPropertyNames, this.annotatedPropertyNames);
    }

    private Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private boolean attachValidationActions(TaskPropertyInfo propertyInfo) {
        boolean annotationFound = false;
        for (PropertyAnnotationHandler propertyAnnotationHandler : HANDLERS) {
            annotationFound |= this.attachValidationAction(propertyAnnotationHandler, propertyInfo);
        }
        return annotationFound;
    }

    private boolean attachValidationAction(PropertyAnnotationHandler handler, TaskPropertyInfo propertyInfo) {
        Class<? extends Annotation> annotationType = handler.getAnnotationType();
        if (!propertyInfo.isAnnotationPresent(annotationType)) {
            return false;
        }
        if (handler.getMustNotBeNullByDefault() && !propertyInfo.isAnnotationPresent(Optional.class)) {
            propertyInfo.setNotNullValidator(NOT_NULL_VALIDATOR);
        }
        propertyInfo.attachActions(handler);
        return true;
    }
}

