/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.osgi.SpringOsgiBundle;
import com.intellij.spring.osgi.inspections.SpringOsgiBaseInspection;
import com.intellij.spring.osgi.model.converters.ReferenceListenerMethodConverter;
import com.intellij.spring.osgi.model.xml.BaseOsgiReference;
import com.intellij.spring.osgi.model.xml.Listener;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringOsgiListenerInspection
extends SpringOsgiBaseInspection {
    @Override
    protected void checkOsgiReference(BaseOsgiReference reference, Beans beans, DomElementAnnotationHolder holder, SpringModel springModel) {
        for (Listener listener : reference.getListeners()) {
            this.checkBindMethodsSignature(listener, holder);
            this.checkListenerClass(listener, holder);
        }
    }

    private void checkListenerClass(Listener listener, DomElementAnnotationHolder holder) {
        SpringBean bean;
        if (listener.getBindMethod().getValue() != null && listener.getUnbindMethod().getValue() != null) {
            return;
        }
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)listener.getRef().getValue();
        if (springBeanPointer != null) {
            this.checkListenerClass(holder, springBeanPointer.getBeanClass(), (DomElement)listener.getRef());
        }
        if ((bean = listener.getBean()) != null) {
            this.checkListenerClass(holder, PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType()), (DomElement)bean);
        }
    }

    private void checkListenerClass(DomElementAnnotationHolder holder, @Nullable PsiClass psiClass, DomElement element) {
        if (psiClass == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.osgi.service.importer.OsgiServiceLifecycleListener")) {
            holder.createProblem(element, SpringOsgiBundle.message("model.inspection.listener.class.extends", "org.springframework.osgi.service.importer.OsgiServiceLifecycleListener"), new LocalQuickFix[0]);
        }
    }

    private void checkBindMethodsSignature(Listener listener, DomElementAnnotationHolder holder) {
        this.checkMethodSignature(listener.getBindMethod(), holder);
        this.checkMethodSignature(listener.getUnbindMethod(), holder);
    }

    private void checkMethodSignature(GenericAttributeValue<PsiMethod> method, DomElementAnnotationHolder holder) {
        PsiMethod psiMethod = (PsiMethod)method.getValue();
        if (psiMethod != null) {
            PsiType returnType = psiMethod.getReturnType();
            if (!PsiType.VOID.equals((Object)returnType)) {
                holder.createProblem(method, SpringOsgiBundle.message("model.inspection.listener.common.method.return.type", new Object[0]), new LocalQuickFix[0]);
            }
            if (!psiMethod.getModifierList().hasModifierProperty("public")) {
                holder.createProblem(method, SpringOsgiBundle.message("model.inspection.listener.common.method.public", new Object[0]), new LocalQuickFix[0]);
            }
            if (!ReferenceListenerMethodConverter.checkProperParameters(psiMethod)) {
                holder.createProblem(method, SpringOsgiBundle.message("model.inspection.listener.common.method.parameters", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringOsgiListenerInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/osgi/inspections/SpringOsgiListenerInspection", "getShortName"));
        }
        return "SpringOsgiListenerInspection";
    }
}

