/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"canUseGitExe", "", "getCredentialsUsingGit", "Lcom/intellij/credentialStore/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "settings-repository"})
public final class GitCredentialKt {
    private static boolean canUseGitExe = true;

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository2) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        if (!canUseGitExe || repository2.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"git", "credential", "fill"});
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"commandLine.createProcess()");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStream outputStream = process.getOutputStream();
        Object object = null;
        boolean bl = true;
        Object var8_10 = null;
        if (var8_10 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writer");
        }
        if (bl & true) {
            object = Charsets.UTF_8;
        }
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, (Charset)object);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        object = process.getInputStream();
        Charset charset = null;
        boolean bl2 = true;
        Object object2 = null;
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (bl2 & true) {
            charset = Charsets.UTF_8;
        }
        object2 = object;
        object2 = new InputStreamReader((InputStream)object2, charset);
        int n = 0;
        boolean bl3 = true;
        Object var12_17 = null;
        if (var12_17 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl3 & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        BufferedReader reader = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string;
            String string2 = reader.readLine();
            if (string2 != null) {
                object2 = string2;
                Object object3 = object2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
            } else {
                string = line = null;
            }
            if (line == null) break;
            object2 = line;
            if (object2.length() == 0) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    String string = this.$line;
                    int n = StringsKt.indexOf$default((CharSequence)this.$line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    string = string3;
                    String string4 = string;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    return ((Object)StringsKt.trim((CharSequence)string4)).toString();
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2, null)) {
                username = readValue$.invoke();
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2, null)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        object2 = process.getErrorStream();
        Charset charset2 = null;
        bl3 = true;
        var12_17 = null;
        if (var12_17 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl3 & true) {
            charset2 = Charsets.UTF_8;
        }
        String errorText = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object2, charset2));
        object2 = errorText;
        if (object2.length() > 0) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? (Credentials)null : new Credentials((String)username, (String)password);
    }
}

