/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.files;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.play.language.PlayCompositeElement;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayStructureViewModel
extends TextEditorBasedStructureViewModel {
    private final PlayPsiFile myFile;

    public PlayStructureViewModel(PlayPsiFile file) {
        super((PsiFile)file);
        this.myFile = file;
    }

    protected PsiFile getPsiFile() {
        return this.myFile;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PlayPsiFilePsiTreeElementBase playPsiFilePsiTreeElementBase = new PlayPsiFilePsiTreeElementBase();
        if (playPsiFilePsiTreeElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/files/PlayStructureViewModel", "getRoot"));
        }
        return playPsiFilePsiTreeElementBase;
    }

    private class PlayPsiFilePsiTreeElementBase
    extends PsiTreeElementBase<PlayPsiFile> {
        public PlayPsiFilePsiTreeElementBase() {
            super((PsiElement)PlayStructureViewModel.this.myFile);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            ArrayList<StructureViewTreeElement> treeElements = new ArrayList<StructureViewTreeElement>();
            PlayPsiFile file = (PlayPsiFile)this.getElement();
            if (file != null) {
                for (PlayTag playTag : file.getRootTags()) {
                    treeElements.add((StructureViewTreeElement)new PlayTagPsiTreeElementBase(playTag));
                }
            }
            ArrayList<StructureViewTreeElement> arrayList = treeElements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/files/PlayStructureViewModel$PlayPsiFilePsiTreeElementBase", "getChildrenBase"));
            }
            return arrayList;
        }

        public String getPresentableText() {
            PlayPsiFile file = (PlayPsiFile)this.getElement();
            return file == null ? "Play" : file.getPresentableName();
        }
    }

    private static class PlayTagPsiTreeElementBase
    extends PsiTreeElementBase<PlayTag> {
        public PlayTagPsiTreeElementBase(@NotNull PlayTag playTag) {
            if (playTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playTag", "com/intellij/play/files/PlayStructureViewModel$PlayTagPsiTreeElementBase", "<init>"));
            }
            super((PsiElement)playTag);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
            PlayTag playTag = (PlayTag)this.getElement();
            if (playTag != null && playTag.isValid()) {
                for (PlayTag subtag : playTag.getSubTags()) {
                    children.add((StructureViewTreeElement)new PlayTagPsiTreeElementBase(subtag));
                }
            }
            ArrayList<StructureViewTreeElement> arrayList = children;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/files/PlayStructureViewModel$PlayTagPsiTreeElementBase", "getChildrenBase"));
            }
            return arrayList;
        }

        public String getPresentableText() {
            PlayTag playTag = (PlayTag)this.getElement();
            if (playTag != null && playTag.isValid()) {
                return playTag.getName();
            }
            return "";
        }

        public String getLocationString() {
            PlayTag playTag = (PlayTag)this.getElement();
            if (playTag != null && playTag.isValid()) {
                PlayCompositeElement[] nameValues = playTag.getNameValues();
                if (nameValues.length != 0) {
                    return this.elementsToString(nameValues);
                }
                PlayCompositeElement[] actions = playTag.getActions();
                if (actions.length > 0) {
                    return this.elementsToString(actions, "@");
                }
                return this.elementsToString(playTag.getTagExpressions());
            }
            return null;
        }

        @Nullable
        private String elementsToString(PlayCompositeElement[] nameValues) {
            return this.elementsToString(nameValues, "");
        }

        @Nullable
        private String elementsToString(PlayCompositeElement[] nameValues, String prefix) {
            if (nameValues.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (PlayCompositeElement nameValue : nameValues) {
                sb.append(prefix);
                sb.append(nameValue.getText());
                sb.append(" ");
            }
            return sb.toString();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            ItemPresentation itemPresentation = super.getPresentation();
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/files/PlayStructureViewModel$PlayTagPsiTreeElementBase", "getPresentation"));
            }
            return itemPresentation;
        }

        public Icon getIcon(boolean open) {
            return super.getIcon(open);
        }
    }
}

