/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlayFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/play/language/PlayFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/play/language/PlayFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement element = node.getPsi();
        if (element instanceof PlayPsiFile) {
            PlayPsiFile file = (PlayPsiFile)element;
            ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
            for (PlayTag playTag : file.getRootTags()) {
                PlayFoldingBuilder.addFoldingDescriptors(descriptors, playTag);
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayFoldingBuilder", "buildFoldRegions"));
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayFoldingBuilder", "buildFoldRegions"));
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, PlayTag tag) {
        int end;
        int start;
        if (!tag.textContains('\n')) {
            return;
        }
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null && (start = nameElement.getTextRange().getEndOffset()) + 1 < (end = tag.getTextRange().getEndOffset() - 1)) {
            descriptors.add(new FoldingDescriptor(tag.getNode(), new TextRange(start, end)));
            for (PlayTag child : tag.getSubTags()) {
                PlayFoldingBuilder.addFoldingDescriptors(descriptors, child);
            }
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/play/language/PlayFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/play/language/PlayFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

