/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverterImpl;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringBeanNameConventionInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringBeanNameConventionInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringBeanNameConventionInspection", "getShortName"));
        }
        return "SpringBeanNameConventionInspection";
    }

    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        GenericAttributeValue springBeanId = springBean.getId();
        if (!DomUtil.hasXml((DomElement)springBeanId)) {
            return;
        }
        String beanId = springBeanId.getStringValue();
        if (SpringBeanNameConventionInspection.acceptBean(springBean, beanId)) {
            SpringBeanNameConventionInspection.checkName((DomElement)springBeanId, beanId, holder);
        }
    }

    private static boolean acceptBean(SpringBean springBean, String beanId) {
        return !StringUtil.isEmpty((String)beanId) && !SpringBeanNameConventionInspection.hasSymbols(beanId, ".") && !SpringBeanNameConventionInspection.hasSymbols(beanId, "-") && (!FieldRetrievingFactoryBeanConverterImpl.isFieldRetrievingFactoryBean((CommonSpringBean)springBean) || !FieldRetrievingFactoryBeanConverterImpl.isResolved(springBean.getManager().getProject(), beanId));
    }

    private static boolean hasSymbols(@NotNull String beanId, @NotNull String smb) {
        if (beanId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanId", "com/intellij/spring/model/highlighting/SpringBeanNameConventionInspection", "hasSymbols"));
        }
        if (smb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smb", "com/intellij/spring/model/highlighting/SpringBeanNameConventionInspection", "hasSymbols"));
        }
        if (!beanId.contains(smb)) {
            return false;
        }
        for (String s : StringUtil.split((String)beanId, (String)smb, (boolean)true, (boolean)false)) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) continue;
            return false;
        }
        return true;
    }

    private static void checkAlias(Alias alias, DomElementAnnotationHolder holder) {
        String aliasName = alias.getAlias().getStringValue();
        SpringBeanNameConventionInspection.checkName((DomElement)alias.getAlias(), aliasName, holder);
    }

    private static void checkName(DomElement domElement, @NotNull String name, DomElementAnnotationHolder holder) {
        boolean keyword;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/highlighting/SpringBeanNameConventionInspection", "checkName"));
        }
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)domElement.getManager().getProject());
        boolean identifier = psiNameHelper.isIdentifier(name);
        if (!identifier && !(keyword = psiNameHelper.isKeyword(name))) {
            holder.createProblem(domElement, SpringBundle.message("model.inspection.invalid.identifier.message", name), new LocalQuickFix[0]);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            holder.createProblem(domElement, SpringBundle.message("model.inspection.invalid.lowercase.name.message", name), new LocalQuickFix[0]);
        }
    }
}

