/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSpringBeanQueryExecutor
extends QueryExecutorBase<SpringBeanPointer, SpringBeanSearchParameters.BeanClass> {
    public static boolean processEffectiveBeanTypes(@NotNull Collection<SpringBeanPointer> pointers, @NotNull SpringBeanSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/utils/search/executors/AbstractSpringBeanQueryExecutor", "processEffectiveBeanTypes"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/AbstractSpringBeanQueryExecutor", "processEffectiveBeanTypes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/utils/search/executors/AbstractSpringBeanQueryExecutor", "processEffectiveBeanTypes"));
        }
        for (SpringBeanPointer pointer : pointers) {
            ProgressManager.checkCanceled();
            for (PsiType psiType : pointer.getEffectiveBeanTypes()) {
                if (!params.matchesClass(psiType) || processor.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    }
}

