/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.components;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkElementVirtualFileProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkVirtualFileSystem
extends DummyCachingFileSystem<FrameworkElementAsVirtualFileImpl> {
    @NonNls
    private static final String PROTOCOL = "javaeeDummy";
    @NonNls
    private static final String PATH_PREFIX = "JavaeeElement:/";
    private final NotNullLazyValue<FrameworkElementVirtualFileProvider[]> myFileProviders = new NotNullLazyValue<FrameworkElementVirtualFileProvider[]>(){

        @NotNull
        protected FrameworkElementVirtualFileProvider[] compute() {
            FrameworkElementVirtualFileProvider[] frameworkElementVirtualFileProviderArray = (FrameworkElementVirtualFileProvider[])Extensions.getExtensions(FrameworkElementVirtualFileProvider.EXTENSION_POINT_NAME);
            if (frameworkElementVirtualFileProviderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkVirtualFileSystem$1", "compute"));
            }
            return frameworkElementVirtualFileProviderArray;
        }
    };

    public static FrameworkVirtualFileSystem getJ2EEInstance() {
        return (FrameworkVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public FrameworkVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(Project project) {
        super.onProjectOpened(project);
        FacetPointersManager.getInstance((Project)project).addListener(JavaeeFacet.class, (FacetPointerListener)new FacetPointerListener<JavaeeFacet>(){

            public void pointerIdChanged(FacetPointer<JavaeeFacet> facetPointer, String oldId) {
                String oldPath = FrameworkVirtualFileSystem.getPath(facetPointer.getProject(), oldId, "Facet", "");
                String oldFacetName = FacetPointersManager.getFacetName((String)oldId);
                String newFacetName = facetPointer.getFacetName();
                FrameworkElementAsVirtualFileImpl file = (FrameworkElementAsVirtualFileImpl)FrameworkVirtualFileSystem.this.findFileByPath(oldPath);
                if (file != null && !oldFacetName.equals(newFacetName)) {
                    FrameworkVirtualFileSystem.this.beforeFileRename(file, this, oldFacetName, newFacetName);
                    FrameworkVirtualFileSystem.this.clearCache();
                    file = (FrameworkElementAsVirtualFileImpl)FrameworkVirtualFileSystem.this.findFileByPath(oldPath);
                    FrameworkVirtualFileSystem.this.fileRenamed(file, this, oldFacetName, newFacetName);
                } else {
                    FrameworkVirtualFileSystem.this.clearCache();
                }
            }
        }, (Disposable)project);
    }

    @Nullable
    public FrameworkElementAsVirtualFileImpl findFileByPathInner(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/module/components/FrameworkVirtualFileSystem", "findFileByPathInner"));
        }
        if (!path.startsWith(PATH_PREFIX)) {
            return null;
        }
        int projectIdEnd = path.indexOf(47, PATH_PREFIX.length());
        if (projectIdEnd == -1) {
            return null;
        }
        String projectId = path.substring(PATH_PREFIX.length(), projectIdEnd);
        int nameEnd = path.indexOf(47, projectIdEnd + 1);
        if (nameEnd == -1) {
            return null;
        }
        String elementName = FrameworkVirtualFileSystem.unescapeSlash((String)path.substring(projectIdEnd + 1, nameEnd));
        int typeStart = path.lastIndexOf(47);
        if (typeStart == -1 || typeStart <= nameEnd) {
            return null;
        }
        String elementType = path.substring(typeStart + 1);
        String facetId = path.substring(nameEnd + 1, typeStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        FacetPointer facetPointer = FacetPointersManager.getInstance((Project)project).create(facetId);
        for (FrameworkElementVirtualFileProvider provider : (FrameworkElementVirtualFileProvider[])this.myFileProviders.getValue()) {
            FrameworkElementAsVirtualFileImpl file = provider.createFileByPath((FacetPointer<? extends Facet>)facetPointer, elementType, elementName);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public static String getPath(@NotNull FacetPointer<? extends Facet> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetPointer", "com/intellij/javaee/module/components/FrameworkVirtualFileSystem", "getPath"));
        }
        return FrameworkVirtualFileSystem.getPath(facetPointer.getProject(), facetPointer.getId(), elementType, elementName);
    }

    public static String getPath(@NotNull Project project, String facetPointerId, String elementType, String elementName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/module/components/FrameworkVirtualFileSystem", "getPath"));
        }
        return PATH_PREFIX + project.getLocationHash() + "/" + FrameworkVirtualFileSystem.escapeSlash((String)elementName) + "/" + facetPointerId + "/" + elementType;
    }

    protected void doRenameFile(VirtualFile vFile, String newName) {
        ((FrameworkElementAsVirtualFileImpl)vFile).setElementName(newName);
    }
}

