/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.ejbLevel;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.EjbType;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.module.view.common.InheritedClassBrowseButtonListener;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbPrefixNameSuffixPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

public class EjbClassesPropertiesPanel {
    private TextFieldWithBrowseButton myDefaultPackage;
    private JCheckBox myEnableRemoteInterface;
    private TextFieldWithBrowseButton myRemoteHome;
    private String myOldEjbName = "";
    private TextFieldWithBrowseButton myRemoteComponent;
    private TextFieldWithBrowseButton myEjbClass;
    private JCheckBox myEnableLocalInterface;
    private TextFieldWithBrowseButton myLocalHome;
    private TextFieldWithBrowseButton myLocalComponent;
    private TextFieldWithBrowseButton myPrimaryKeyClass;
    private JPanel myPanel;
    private JPanel myEjbNamePanel;
    private JComboBox myCmpVersion;
    private JLabel myCmpVersionLabel;
    private TextFieldWithBrowseButton myServiceEndpointInterface;
    private TextFieldWithBrowseButton myMessageListenerInterface;
    private JLabel myPKLabel;
    private JCheckBox myEnableServiceEndpointInterface;
    private JLabel myMessageListenerLabel;
    private JLabel myRemoteHomeLabel;
    private JLabel myRemoteComponentLabel;
    private JLabel myLocalHomeLabel;
    private JLabel myLocalComponentLabel;
    private JPanel myLocalPanel;
    private JPanel myRemotePanel;
    private JLabel myPackageLabel;
    private JLabel myEjbClassLabel;
    private final JavaeeCodeStyleSettings myCodeStyleSettings;
    private String myOldDefaultPackage;
    private final EjbPrefixNameSuffixPanel myPrefixNameSuffixPanel;
    private final EjbDataHolder myEjbInfo;
    private final EjbRootElement myEjbModel;
    private final Project myProject;
    private final boolean myIsCreation;
    private final JComponent[] myLocalComponents;
    private final JComponent[] myRemoteComponents;

    public EjbClassesPropertiesPanel(EjbRootElement ejbRootElement, EjbDataHolder ejbInfo, Project project, boolean isCreation, boolean shouldAllowRenaming) {
        this.myIsCreation = isCreation;
        this.myEjbModel = ejbRootElement;
        this.myProject = project;
        this.myEjbInfo = ejbInfo;
        this.$$$setupUI$$$();
        this.myCodeStyleSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaeeCodeStyleSettings.class);
        this.myEjbNamePanel.setLayout(new BorderLayout());
        this.myPrefixNameSuffixPanel = this.createPrefixNameSuffixPanel();
        this.myPrefixNameSuffixPanel.setUniqueName(ejbInfo.getPureName());
        this.myEjbNamePanel.add((Component)this.myPrefixNameSuffixPanel.getComponent(), "Center");
        if (!shouldAllowRenaming) {
            this.myPrefixNameSuffixPanel.setEnabled(false);
        }
        if (!isCreation) {
            GuiUtils.enableChildren((boolean)false, (Component[])new Component[]{this.myEjbClass});
        }
        this.myLocalComponents = new JComponent[]{this.myLocalComponent, this.myLocalComponentLabel, this.myLocalHome, this.myLocalHomeLabel};
        this.myRemoteComponents = new JComponent[]{this.myRemoteComponent, this.myRemoteComponentLabel, this.myRemoteHome, this.myRemoteHomeLabel};
        this.setupControls();
        this.changeControlsType();
        this.refreshControls();
        this.myPrefixNameSuffixPanel.selectAll();
    }

    private EjbPrefixNameSuffixPanel createPrefixNameSuffixPanel() {
        return new EjbPrefixNameSuffixPanel(this.myEjbModel.getModule(), this.getType(), this.myOldEjbName){

            @Override
            public void nameChanged() {
                EjbClassesPropertiesPanel.this.ejbNameOrPackageChanged();
                EjbClassesPropertiesPanel.this.updateOKAction();
            }

            @Override
            public void codeStyleChanged() {
                EjbClassesPropertiesPanel.this.myEjbInfo.setName(EjbClassesPropertiesPanel.this.getBeanName());
                EjbClassesPropertiesPanel.this.myEjbInfo.setPackage(EjbClassesPropertiesPanel.this.getDefaultPackageName());
                EjbClassesPropertiesPanel.this.refreshControls();
            }
        };
    }

    private void changeControlsType() {
        EjbDescriptorVersion ejbVersion = EjbUtil.getVersion((JavaeeModelElement)this.myEjbModel);
        boolean ejb30Creation = this.myIsCreation && EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbVersion) <= 0;
        boolean showRemote = this.isEntityBean() || this.isSessionBean() && !ejb30Creation;
        boolean showLocal = showRemote && ejbVersion != EjbDescriptorVersion.EJB_VERSION_1_X;
        boolean showServiceEndpoint = this.isSessionBean() && this.myEjbInfo.getSessionType() != SessionType.STATEFUL && EjbDescriptorVersion.EJB_VERSION_2_1.compareTo((Enum)EjbUtil.getVersion((JavaeeModelElement)this.myEjbModel)) <= 0 && !ejb30Creation;
        GuiUtils.showComponents((boolean)showRemote, (Component[])this.myRemoteComponents);
        GuiUtils.showComponents((boolean)showRemote, (Component[])new Component[]{this.myRemotePanel});
        GuiUtils.showComponents((boolean)showLocal, (Component[])new Component[]{this.myLocalPanel});
        GuiUtils.showComponents((boolean)showLocal, (Component[])this.myLocalComponents);
        GuiUtils.showComponents((boolean)this.isMessageBean(), (Component[])new Component[]{this.myMessageListenerLabel});
        GuiUtils.showComponents((boolean)this.isMessageBean(), (Component[])new Component[]{this.myMessageListenerInterface});
        GuiUtils.showComponents((boolean)showServiceEndpoint, (Component[])new Component[]{this.myServiceEndpointInterface});
        GuiUtils.showComponents((boolean)showServiceEndpoint, (Component[])new Component[]{this.myEnableServiceEndpointInterface});
        if (showRemote && !showLocal) {
            this.myEnableRemoteInterface.setEnabled(false);
            this.myEnableRemoteInterface.setSelected(true);
        }
        if (!this.isEntityBean()) {
            this.myPrimaryKeyClass.setVisible(false);
            this.myPKLabel.setVisible(false);
            this.myCmpVersion.setVisible(false);
            this.myCmpVersionLabel.setVisible(false);
        }
        boolean showCmpVersion = this.myIsCreation && this.isEntityBean() && this.myEjbInfo.getPersistenceType() == PersistenceType.CONTAINER && EjbDescriptorVersion.EJB_VERSION_1_X.compareTo((Enum)ejbVersion) < 0;
        this.myCmpVersion.setEnabled(showCmpVersion);
        this.myCmpVersionLabel.setEnabled(showCmpVersion);
        this.myPanel.doLayout();
    }

    private boolean isEntityBean() {
        return this.myEjbInfo.getEjbType() == EjbType.Entity;
    }

    private boolean isMessageBean() {
        return this.myEjbInfo.getEjbType() == EjbType.Message;
    }

    private void refreshControls() {
        CmpVersion cmpVersion = this.myEjbInfo.getCmpVersion();
        this.myCmpVersion.setSelectedIndex(cmpVersion == null ? 0 : cmpVersion.ordinal());
        String targetPackageName = this.myEjbInfo.getPackage();
        this.myDefaultPackage.setText(targetPackageName != null ? targetPackageName : "");
        this.myEjbClass.setText(this.myEjbInfo.getClassName());
        this.myRemoteHome.setText(this.myEjbInfo.getRemoteHomeInterfaceName());
        this.myRemoteComponent.setText(this.myEjbInfo.getRemoteInterfaceName());
        this.myLocalHome.setText(this.myEjbInfo.getLocalHomeInterfaceName());
        this.myLocalComponent.setText(this.myEjbInfo.getLocalInterfaceName());
        this.myEnableRemoteInterface.setSelected(this.myEjbInfo.isGenerateRemote());
        this.myEnableLocalInterface.setSelected(this.myEjbInfo.isGenerateLocal());
        this.myEnableServiceEndpointInterface.setSelected(this.myEnableServiceEndpointInterface.isVisible() && this.myEjbInfo.isGenerateLocal());
        this.myServiceEndpointInterface.setText(this.myEjbInfo.getServiceEndpointInterface());
        this.myMessageListenerInterface.setText(this.myEjbInfo.getMessageListenerInterface());
        this.remoteInterfaceChanged();
        this.localInterfaceChanged();
        this.serviceEndpointInterfaceChanged();
        GuiUtils.enableChildren((Component)this.myMessageListenerInterface, (EjbDescriptorVersion.EJB_VERSION_2_1.compareTo((Enum)EjbUtil.getVersion((JavaeeModelElement)this.myEjbModel)) <= 0 ? 1 : 0) != 0, (JComponent[])new JComponent[0]);
        this.updateOKAction();
        this.myPrefixNameSuffixPanel.setFullNameAndUpdate(this.myEjbInfo.getName());
        this.ejbNameOrPackageChanged();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPrefixNameSuffixPanel.getPreferredFocusedComponent();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myDefaultPackage.setTextFieldPreferredWidth(30);
        this.myEjbClass.setTextFieldPreferredWidth(30);
        this.myDefaultPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog chooser = new PackageChooserDialog(J2EEBundle.message((String)"dialog.title.choose.ejb.classes.package", (Object[])new Object[0]), EjbClassesPropertiesPanel.this.myProject);
                chooser.selectPackage(EjbClassesPropertiesPanel.this.myDefaultPackage.getText());
                chooser.show();
                PsiPackage aPackage = chooser.getSelectedPackage();
                if (aPackage != null) {
                    EjbClassesPropertiesPanel.this.myDefaultPackage.setText(aPackage.getQualifiedName());
                }
            }
        });
        this.myDefaultPackage.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> EjbClassesPropertiesPanel.this.ejbNameOrPackageChanged());
            }
        });
        this.myEnableRemoteInterface.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EjbClassesPropertiesPanel.this.remoteInterfaceChanged();
            }
        });
        this.myEnableLocalInterface.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EjbClassesPropertiesPanel.this.localInterfaceChanged();
            }
        });
        this.myEnableServiceEndpointInterface.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EjbClassesPropertiesPanel.this.serviceEndpointInterfaceChanged();
            }
        });
        String ejbBaseClass = this.myEjbInfo.getEjbType() == EjbType.Entity ? "javax.ejb.EntityBean" : (this.myEjbInfo.getEjbType() == EjbType.Session ? "javax.ejb.SessionBean" : "javax.ejb.MessageDrivenBean");
        this.setupTextField(this.myEjbClass, ejbBaseClass, J2EEBundle.message((String)"dialog.title.choose.ejb.class", (Object[])new Object[0]));
        this.setupTextField(this.myRemoteHome, "javax.ejb.EJBHome", J2EEBundle.message((String)"dialog.title.choose.ejb.home.interface", (Object[])new Object[0]));
        this.setupTextField(this.myRemoteComponent, "javax.ejb.EJBObject", J2EEBundle.message((String)"dialog.title.choose.ejb.remote.interface", (Object[])new Object[0]));
        this.setupTextField(this.myLocalHome, "javax.ejb.EJBLocalHome", J2EEBundle.message((String)"dialog.title.choose.ejb.local.home.interface", (Object[])new Object[0]));
        this.setupTextField(this.myLocalComponent, "javax.ejb.EJBLocalObject", J2EEBundle.message((String)"dialog.title.choose.ejb.local.interface", (Object[])new Object[0]));
        this.setupTextField(this.myPrimaryKeyClass, null, J2EEBundle.message((String)"dialog.title.choose.ejb.primary.key.class", (Object[])new Object[0]));
        this.setupTextField(this.myMessageListenerInterface, null, J2EEBundle.message((String)"dialog.title.choose.ejb.message.listener.interface", (Object[])new Object[0]));
        this.setupTextField(this.myServiceEndpointInterface, null, J2EEBundle.message((String)"dialog.title.choose.ejb.service.endpoint.interface", (Object[])new Object[0]));
        this.myEjbClassLabel.setLabelFor(this.myEjbClass.getTextField());
        this.myLocalComponentLabel.setLabelFor(this.myLocalComponent.getTextField());
        this.myLocalHomeLabel.setLabelFor(this.myLocalHome.getTextField());
        this.myRemoteHomeLabel.setLabelFor(this.myRemoteHome.getTextField());
        this.myRemoteHomeLabel.setLabelFor(this.myRemoteHome.getTextField());
        this.myPKLabel.setLabelFor(this.myPrimaryKeyClass.getTextField());
        this.myPackageLabel.setLabelFor(this.myDefaultPackage.getTextField());
        this.myMessageListenerLabel.setLabelFor(this.myMessageListenerInterface.getTextField());
        this.myPrimaryKeyClass.setText(this.myEjbInfo.getPKClassName());
        this.myCmpVersion.addItem(CmpVersion.CmpVersion_1_X.getValue());
        this.myCmpVersion.addItem(CmpVersion.CmpVersion_2_X.getValue());
        this.myMessageListenerInterface.setText(this.myEjbInfo.getMessageListenerInterface());
        this.myServiceEndpointInterface.setText(this.myEjbInfo.getServiceEndpointInterface());
    }

    private void setupTextField(TextFieldWithBrowseButton field, String baseClass, String dialogTitle) {
        this.addChangeListener(field);
        field.addActionListener((ActionListener)new InheritedClassBrowseButtonListener(baseClass, dialogTitle, this.myProject));
    }

    private void addChangeListener(TextFieldWithBrowseButton textFieldWithBrowseButton) {
        textFieldWithBrowseButton.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EjbClassesPropertiesPanel.this.updateOKAction();
            }
        });
    }

    private void localInterfaceChanged() {
        GuiUtils.enableChildren((this.myEnableLocalInterface.isSelected() && (this.myIsCreation || !this.myEjbInfo.isGenerateLocal()) ? 1 : 0) != 0, (Component[])this.myLocalComponents);
        this.ejbNameOrPackageChanged();
        this.updateOKAction();
    }

    private void remoteInterfaceChanged() {
        GuiUtils.enableChildren((this.myEnableRemoteInterface.isSelected() && (this.myIsCreation || !this.myEjbInfo.isGenerateRemote()) ? 1 : 0) != 0, (Component[])this.myRemoteComponents);
        this.ejbNameOrPackageChanged();
        this.updateOKAction();
    }

    private void serviceEndpointInterfaceChanged() {
        GuiUtils.enableChildren((this.myEnableServiceEndpointInterface.isSelected() && (this.myIsCreation || this.myEjbInfo.isGenerateServiceEndpoint()) ? 1 : 0) != 0, (Component[])new Component[]{this.myServiceEndpointInterface});
        this.ejbNameOrPackageChanged();
        this.updateOKAction();
    }

    protected void updateOKAction() {
    }

    public boolean isOKActionEnabled() {
        boolean ejb3 = EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion((JavaeeModelElement)this.myEjbModel)) <= 0;
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        return !(!ejb3 && !this.myEnableRemoteInterface.isSelected() && !this.myEnableLocalInterface.isSelected() && !this.isMessageBean() || !nameHelper.isIdentifier(this.getBeanName()) || !nameHelper.isQualifiedName(this.getEjbClassName()) || !"".equals(this.getDefaultPackageName()) && !nameHelper.isQualifiedName(this.getDefaultPackageName()) || this.myEnableRemoteInterface.isSelected() && (!nameHelper.isQualifiedName(this.getHomeInterfaceName()) || !nameHelper.isQualifiedName(this.getRemoteInterfaceName())) || this.myEnableLocalInterface.isSelected() && (!nameHelper.isQualifiedName(this.getLocalHomeInterfaceName()) || !nameHelper.isQualifiedName(this.getLocalInterfaceName())) || this.myEnableServiceEndpointInterface.isSelected() && !nameHelper.isQualifiedName(this.getServiceEndpointInterface()));
    }

    private void ejbNameOrPackageChanged() {
        boolean entity = this.isEntityBean();
        if (this.generateRemoteInterface()) {
            this.updateNameField(this.myRemoteHome, entity ? this.myCodeStyleSettings.ENTITY_HI_PREFIX : this.myCodeStyleSettings.SESSION_HI_PREFIX, entity ? this.myCodeStyleSettings.ENTITY_HI_SUFFIX : this.myCodeStyleSettings.SESSION_HI_SUFFIX);
            this.updateNameField(this.myRemoteComponent, entity ? this.myCodeStyleSettings.ENTITY_RI_PREFIX : this.myCodeStyleSettings.SESSION_RI_PREFIX, entity ? this.myCodeStyleSettings.ENTITY_RI_SUFFIX : this.myCodeStyleSettings.SESSION_RI_SUFFIX);
        }
        if (this.myIsCreation) {
            boolean session = this.isSessionBean();
            this.updateNameField(this.myEjbClass, entity ? this.myCodeStyleSettings.ENTITY_EB_PREFIX : (session ? this.myCodeStyleSettings.SESSION_EB_PREFIX : this.myCodeStyleSettings.MESSAGE_EB_PREFIX), entity ? this.myCodeStyleSettings.ENTITY_EB_SUFFIX : (session ? this.myCodeStyleSettings.SESSION_EB_SUFFIX : this.myCodeStyleSettings.MESSAGE_EB_SUFFIX));
            this.updateNameField(this.myPrimaryKeyClass, "", "PK");
        }
        if (this.generateLocalInterface()) {
            this.updateNameField(this.myLocalHome, entity ? this.myCodeStyleSettings.ENTITY_LHI_PREFIX : this.myCodeStyleSettings.SESSION_LHI_PREFIX, entity ? this.myCodeStyleSettings.ENTITY_LHI_SUFFIX : this.myCodeStyleSettings.SESSION_LHI_SUFFIX);
            this.updateNameField(this.myLocalComponent, entity ? this.myCodeStyleSettings.ENTITY_LI_PREFIX : this.myCodeStyleSettings.SESSION_LI_PREFIX, entity ? this.myCodeStyleSettings.ENTITY_LI_SUFFIX : this.myCodeStyleSettings.SESSION_LI_SUFFIX);
        }
        if (this.generateServiceEndpointInterface()) {
            this.updateNameField(this.myServiceEndpointInterface, this.myCodeStyleSettings.SESSION_SI_PREFIX, this.myCodeStyleSettings.SESSION_SI_SUFFIX);
        }
        this.myOldEjbName = this.myPrefixNameSuffixPanel.getRawName();
        this.myOldDefaultPackage = this.getDefaultPackageName();
    }

    private boolean isSessionBean() {
        return this.myEjbInfo.getEjbType() == EjbType.Session;
    }

    private void updateNameField(TextFieldWithBrowseButton field, @NonNls String prefix, @NonNls String suffix) {
        String className;
        String aPackage;
        if (!field.isVisible()) {
            field.setText("");
            return;
        }
        if (!field.isEnabled()) {
            return;
        }
        String text = field.getText();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'.')) {
            text = text.substring(0, text.length() - 1);
        }
        if ("".equals(aPackage = CreateClassUtil.extractPackage((String)text)) || aPackage.equals(this.myOldDefaultPackage)) {
            aPackage = this.getDefaultPackageName();
        }
        if ("".equals(className = CreateClassUtil.extractClassName((String)text)) || className.equals(prefix + this.myOldEjbName + suffix)) {
            field.setText(CreateClassUtil.makeFQName((String)aPackage, (String)(prefix + this.myPrefixNameSuffixPanel.getRawName() + suffix)));
        }
    }

    private EjbType getType() {
        return this.myEjbInfo.getEjbType();
    }

    private String getDefaultPackageName() {
        String name = this.myDefaultPackage.getText();
        if (name == null) {
            name = "";
        }
        if (StringUtil.endsWithChar((CharSequence)name, (char)'.')) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private String getBeanName() {
        return this.myPrefixNameSuffixPanel.getFullName();
    }

    private String getEjbClassName() {
        return this.myEjbClass.getText();
    }

    private String getRemoteInterfaceName() {
        return this.myRemoteComponent.getText();
    }

    private String getHomeInterfaceName() {
        return this.myRemoteHome.getText();
    }

    private String getLocalHomeInterfaceName() {
        return this.myLocalHome.getText();
    }

    private String getLocalInterfaceName() {
        return this.myLocalComponent.getText();
    }

    private boolean generateRemoteInterface() {
        return this.myEnableRemoteInterface.isSelected();
    }

    private boolean generateLocalInterface() {
        return this.myEnableLocalInterface.isSelected();
    }

    private boolean generateServiceEndpointInterface() {
        return this.myEnableServiceEndpointInterface.isSelected();
    }

    private String getServiceEndpointInterface() {
        return this.myServiceEndpointInterface.getText();
    }

    private String getMessageListenerInterface() {
        return this.myMessageListenerInterface.getText();
    }

    public void saveEjbInfo() {
        this.myEjbInfo.setName(this.getBeanName());
        this.myEjbInfo.setClassName(this.getEjbClassName());
        this.myEjbInfo.setRemoteInterfaceName(this.getRemoteInterfaceName());
        this.myEjbInfo.setRemoteHomeInterfaceName(this.getHomeInterfaceName());
        this.myEjbInfo.setGenerateRemote(this.generateRemoteInterface());
        this.myEjbInfo.setLocalInterfaceName(this.getLocalInterfaceName());
        this.myEjbInfo.setLocalHomeInterfaceName(this.getLocalHomeInterfaceName());
        this.myEjbInfo.setGenerateLocal(this.generateLocalInterface());
        this.myEjbInfo.setServiceEndpointInterface(this.getServiceEndpointInterface());
        this.myEjbInfo.setGenerateServiceEndpoint(this.generateServiceEndpointInterface());
        this.myEjbInfo.setMessageListenerInterface(this.getMessageListenerInterface());
        this.myEjbInfo.setEjbType(this.getType());
        this.myEjbInfo.setPkClassName(this.getPrimaryKeyClassName());
        this.myEjbInfo.setCmpVersion(CmpVersion.values()[this.myCmpVersion.getSelectedIndex()]);
    }

    private String getPrimaryKeyClassName() {
        return this.myPrimaryKeyClass.getText();
    }

    public boolean isDataValid() {
        if (!this.isOKActionEnabled()) {
            return false;
        }
        if (!this.myEjbInfo.checkNameIsUnique()) {
            Messages.showErrorDialog((Project)this.myProject, (String)J2EEBundle.message((String)"message.text.ejb.exists.in.ejb.facet", (Object[])new Object[]{this.myEjbInfo.getName()}), (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton5;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton6;
        JLabel jLabel5;
        JComboBox jComboBox;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton7;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton8;
        JLabel jLabel8;
        TextFieldWithBrowseButton textFieldWithBrowseButton9;
        JLabel jLabel9;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEjbNamePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 0, null, null, null));
        this.myPackageLabel = jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.package"));
        jPanel4.add((Component)jLabel9, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDefaultPackage = textFieldWithBrowseButton9 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton9, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEjbClassLabel = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.ejb.class"));
        jPanel4.add((Component)jLabel8, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEjbClass = textFieldWithBrowseButton8 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton8, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPKLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.primary.key.class"));
        jPanel4.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrimaryKeyClass = textFieldWithBrowseButton7 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton7, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCmpVersionLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.ejb.class.cmp.version"));
        jPanel4.add((Component)jLabel6, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCmpVersion = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(3, 3, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        this.myRemoteHomeLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.remote.interface"));
        jPanel4.add((Component)jLabel5, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteHome = textFieldWithBrowseButton6 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton6, new GridConstraints(7, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRemoteComponentLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.remote"));
        jPanel4.add((Component)jLabel4, new GridConstraints(7, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteComponent = textFieldWithBrowseButton5 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton5, new GridConstraints(7, 3, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRemotePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(6, 0, 1, 4, 8, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 7, null, null, null));
        this.myEnableRemoteInterface = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.ejb.class.enable.remote.interface"));
        jCheckBox3.setSelected(false);
        ((Component)jCheckBox3).setFont(new Font("Tahoma", 0, 11));
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLocalPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(8, 0, 1, 4, 8, 3, 3, 3, null, null, null));
        this.myEnableLocalInterface = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.ejb.class.enable.local.interface"));
        ((Component)jCheckBox2).setFont(new Font("Tahoma", 0, 11));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel.add((Component)jSeparator2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myLocalHomeLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.local.home"));
        jPanel4.add((Component)jLabel3, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalHome = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton4, new GridConstraints(9, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myLocalComponentLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.local"));
        jPanel4.add((Component)jLabel2, new GridConstraints(9, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalComponent = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton3, new GridConstraints(9, 3, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myMessageListenerLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.message.listener.interface"));
        jPanel4.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessageListenerInterface = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(4, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(5, 0, 1, 4, 8, 3, 3, 3, null, null, null));
        this.myEnableServiceEndpointInterface = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.ejb.class.properties.service.endpoint.interface"));
        ((Component)jCheckBox).setFont(new Font("Tahoma", 0, 11));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myServiceEndpointInterface = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel6.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

