/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.cloud.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.context.JavaeeAppFacetContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.cloud.server.CloudIntegration;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudUrlMappingBase
extends ApplicationServerUrlMapping {
    private final CloudIntegration myIntegration;

    public CloudUrlMappingBase(CloudIntegration integration) {
        this.myIntegration = integration;
    }

    protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
        facetContextProvider.add((FacetContextProvider)new JavaeeAppFacetContextProvider());
        facetContextProvider.add((FacetContextProvider)new WebFacetContextProvider(){

            protected String getContextServerSpecific(@NotNull DeploymentModel deploymentModel, @NotNull WebFacet facet) {
                if (deploymentModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/oss/cloud/server/CloudUrlMappingBase$1", "getContextServerSpecific"));
                }
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/oss/cloud/server/CloudUrlMappingBase$1", "getContextServerSpecific"));
                }
                return CloudUrlMappingBase.this.getDeploymentName(deploymentModel);
            }
        });
    }

    protected String getFileContext(DeploymentModel deploymentModel) {
        return this.getDeploymentName(deploymentModel);
    }

    private String getDeploymentName(DeploymentModel deploymentModel) {
        return this.myIntegration.createDeploymentName(deploymentModel);
    }

    protected String doCreateUrl(@NotNull CommonModel serverConfig, @Nullable String context, @Nullable String relativePath) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/intellij/javaee/oss/cloud/server/CloudUrlMappingBase", "doCreateUrl"));
        }
        String result = this.doCreateUrl(serverConfig, context);
        result = StringUtil.isNotEmpty((String)relativePath) ? DeploymentUtil.concatPaths((String[])new String[]{result, relativePath}) : DeploymentUtil.concatPaths((String[])new String[]{result, "/"});
        return result;
    }

    protected abstract String doCreateUrl(@NotNull CommonModel var1, @Nullable String var2);
}

