/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportService;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransportManager {
    private final List<TransportService> myServices = new ArrayList<TransportService>();

    public static TransportManager getInstance() {
        return (TransportManager)ServiceManager.getService(TransportManager.class);
    }

    public TransportManager() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(TransportService.EP_NAME);
        extensionPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<TransportService>(){

            public void extensionAdded(@NotNull TransportService service, @Nullable PluginDescriptor pluginDescriptor) {
                if (service == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/javaee/transport/TransportManager$1", "extensionAdded"));
                }
                TransportManager.this.myServices.add(service);
            }

            public void extensionRemoved(@NotNull TransportService service, @Nullable PluginDescriptor pluginDescriptor) {
                if (service == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/javaee/transport/TransportManager$1", "extensionRemoved"));
                }
                TransportManager.this.myServices.remove(service);
            }
        });
        if (this.myServices.isEmpty()) {
            this.myServices.addAll(Arrays.asList(extensionPoint.getExtensions()));
        }
    }

    public boolean hasServices() {
        return !this.myServices.isEmpty();
    }

    public List<TransportType> getTypes() {
        ArrayList<TransportType> result = new ArrayList<TransportType>();
        for (TransportService service : this.myServices) {
            result.addAll(service.getTypes());
        }
        return result;
    }

    public List<TransportHost> getAllHosts(@Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : this.myServices) {
            result.addAll(service.getHosts(project));
        }
        return result;
    }

    public List<TransportHost> getHostsOfType(TransportType type, @Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : this.myServices) {
            for (TransportHost host : service.getHosts(project)) {
                if (host.getType() != type) continue;
                result.add(host);
            }
        }
        return result;
    }

    @Nullable
    public TransportHost findHost(String hostId, @Nullable Project project) {
        for (TransportService service : this.myServices) {
            for (TransportHost host : service.getHosts(project)) {
                if (!host.getId().equals(hostId)) continue;
                return host;
            }
        }
        return null;
    }

    @Nullable
    public TransportHost editHostsOfType(TransportType type, TransportHost selectedHost) {
        for (TransportService service : this.myServices) {
            if (!service.getTypes().contains(type)) continue;
            return service.editHostsOfType(type, selectedHost);
        }
        return null;
    }

    public static TransportTarget createTarget() {
        TransportTarget result = new TransportTarget();
        result.setId(TransportTarget.getNextId());
        return result;
    }
}

