/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.ide.util.PackageUtil;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Query;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.DatabaseSchemaImporter;
import com.intellij.jpa.generation.JpaMappingGenerator;
import com.intellij.jpa.generation.ORMToAnnotationsConverter;
import com.intellij.jpa.generation.ui.FacetChooserDialog;
import com.intellij.jpa.generation.ui.ImportMappingsDialog;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceMappingsManipulator;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ui.CaptionComponent;
import gnu.trove.THashMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nullable;

public class EjbImporter
implements JpaMappingGenerator {
    private ImportMappingsDialog myDialog;
    private EjbFacet myEjbFacet;
    private PersistenceFacet myFacet;
    private final THashMap<String, PsiDirectory> myDirectories = new THashMap();

    @Override
    public String getTitle() {
        return JpaMessages.message((String)"action.name.generate.persistence.unit.by.entity.beans", (Object[])new Object[0]);
    }

    @Override
    public JpaMappingGenerator clone() {
        return new EjbImporter();
    }

    @Override
    public boolean beforeGenerate(DataContext dataContext) {
        this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        this.myDialog = new ImportMappingsDialog(this.myFacet, unit != null ? (String)unit.getName().getValue() : null){

            @Override
            public void setupTargetControls(JLabel targetLabel, final TextFieldWithBrowseButton targetComponent, CaptionComponent captionComponent) {
                this.setTitle(JpaMessages.message((String)"dialog.title.import.entity.beans", (Object[])new Object[0]));
                targetLabel.setText(JpaMessages.message((String)"label.title.choose.ejb.facet", (Object[])new Object[0]));
                captionComponent.setText(JpaMessages.message((String)"caption.ejb.import.text", (Object[])new Object[0]));
                captionComponent.setDescriptionText(JpaMessages.message((String)"caption.ejb.import.description", (Object[])new Object[0]));
                targetComponent.getTextField().setEditable(false);
                targetComponent.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FacetChooserDialog dialog = new FacetChooserDialog(EjbImporter.this.getProject(), EjbFacet.ID);
                        dialog.setTitle(JpaMessages.message((String)"label.title.choose.ejb.facet", (Object[])new Object[0]));
                        dialog.show();
                        if (dialog.getExitCode() == 0) {
                            EjbImporter.this.myEjbFacet = (EjbFacet)dialog.getSelectedFacet();
                            String name = EjbImporter.this.myEjbFacet.getModule().getName() + "/" + EjbImporter.this.myEjbFacet.getName();
                            targetComponent.getTextField().setText(name);
                        }
                    }
                });
            }
        };
        this.myDialog.show();
        if (this.myDialog.getExitCode() != 0) {
            return false;
        }
        if (ModelMergerUtil.getImplementation((Object)this.getPersistenceMappings(), JamEntityMappings.class) != null) {
            ORMToAnnotationsConverter.ensureJpaApiLibraryExists(this.myFacet.getModule());
        }
        return this.ensurePackagesAreCreated();
    }

    @Override
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistenceFacet facetContext = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        if (facet == null || facetContext == null && unit == null) {
            return false;
        }
        if (unit != null && JamCommonUtil.isInLibrary((CommonModelElement)unit)) {
            return false;
        }
        return !JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, facet.getModule().getProject()).isEmpty();
    }

    public void addAffectedElements(Collection<PsiElement> result) {
        ContainerUtil.addIfNotNull(result, (Object)this.getPersistenceUnit().getIdentifyingPsiElement());
        for (PersistenceMappings mappings : ModelMergerUtil.getFilteredImplementations((Object)this.getPersistenceMappings())) {
            ContainerUtil.addIfNotNull(result, (Object)mappings.getIdentifyingPsiElement());
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)this.myFacet.getModule());
        for (EntityBean entityBean : this.myEjbFacet.getMergedRoot().getEnterpriseBeans().getEntities()) {
            String classNamePK;
            if (entityBean.getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
            String className = this.getNewClassName(entityBean.getEjbClass().getStringValue());
            if (className != null) {
                ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope));
            }
            if ((classNamePK = this.getNewClassName(entityBean.getPrimKeyClass().getStringValue(), "", "")) == null) continue;
            ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(classNamePK, scope));
        }
    }

    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    private PersistenceMappings getPersistenceMappings() {
        return this.myDialog.getPersistenceMapping();
    }

    private PersistencePackage getPersistenceUnit() {
        return this.myDialog.getPersistenceUnit();
    }

    private boolean isGenerateSeparateXmlPerEntity() {
        return this.myDialog.isGenerateSeparateXmlPerEntity();
    }

    @Override
    public VirtualFile[] generate() {
        ArrayList affectedElements = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> this.addAffectedElements(affectedElements));
        Ref resultRef = Ref.create((Object)VirtualFile.EMPTY_ARRAY);
        Ref indicatorRef = Ref.create(null);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(this.getProject(), JpaMessages.message((String)"command.generate.persistence.mappings", (Object[])new Object[]{this.getTitle()}), affectedElements, indicatorRef, new Runnable[]{() -> {
            try {
                if (!this.ensurePackagesAreCreated()) {
                    return;
                }
                resultRef.set((Object)this.buildEntityMappings());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
        return (VirtualFile[])resultRef.get();
    }

    public boolean ensurePackagesAreCreated() {
        for (EntityBean ejb : this.myEjbFacet.getMergedRoot().getEnterpriseBeans().getEntities()) {
            String packageName;
            String fqName;
            if (ejb.getPersistenceType().getValue() != PersistenceType.CONTAINER || (fqName = this.getNewClassName(ejb.getEjbClass().getStringValue())) == null || this.myDirectories.containsKey((Object)(packageName = StringUtil.getPackageName((String)fqName)))) continue;
            try {
                PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage((Module)this.myFacet.getModule(), (String)packageName, null, (boolean)false);
                if (directory == null) {
                    return false;
                }
                this.myDirectories.put((Object)packageName, (Object)directory);
            }
            catch (IncorrectOperationException e) {
                return false;
            }
        }
        return true;
    }

    public VirtualFile[] buildEntityMappings() throws Exception {
        VirtualFile[] virtualFileArray;
        VirtualFile unitFile;
        PersistencePackage unit = this.getPersistenceUnit();
        PersistenceMappings mappings = this.getPersistenceMappings();
        PersistenceUnitManipulator unitManipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)unit, PersistenceUnitManipulator.class);
        if (unitManipulator != null) {
            for (PersistenceMappings persistenceMappings : ModelMergerUtil.getFilteredImplementations((Object)mappings)) {
                unitManipulator.ensureMappingIncluded(persistenceMappings);
            }
        }
        this.buildEntityMappings(this.myFacet.getModule(), unit, mappings);
        VirtualFile virtualFile = unitFile = unit.getContainingFile() == null ? null : unit.getContainingFile().getVirtualFile();
        if (unitFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = unitFile;
        }
        return virtualFileArray;
    }

    @Nullable
    private String getNewClassName(String className) {
        return this.getNewClassName(className, this.myDialog.getEntityNamePrefix(), this.myDialog.getEntityNameSuffix());
    }

    @Nullable
    private String getNewClassName(String className, String prefix, String suffix) {
        return StringUtil.isEmpty((String)className) ? null : this.getQualifiedName(prefix + PsiNameHelper.getShortClassName((String)className) + suffix);
    }

    private String getQualifiedName(String type) {
        String packageName = this.myDialog.getPackageName();
        return type.indexOf(46) < 0 && packageName.length() > 0 ? packageName + '.' + type : type;
    }

    public void buildEntityMappings(Module module, PersistencePackage unit, PersistenceMappings mappings) throws IncorrectOperationException {
        boolean singleXmlPerEntity = this.isGenerateSeparateXmlPerEntity();
        Map.Entry<ConfigFileMetaData, Class<? extends PersistenceMappings>> choosenXmlFormat = singleXmlPerEntity ? this.myFacet.getSupportedDomMappingFormats().entrySet().iterator().next() : null;
        THashMap entityMap = new THashMap();
        for (EntityBean ejb : this.myEjbFacet.getMergedRoot().getEnterpriseBeans().getEntities()) {
            Set<String> pkFieldNames;
            PropertyMemberType accessType;
            if (ejb.getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
            String fqName = this.getNewClassName(ejb.getEjbClass().getStringValue());
            PsiDirectory psiDirectory = (PsiDirectory)this.myDirectories.get((Object)StringUtil.getPackageName((String)fqName));
            String shortName = PsiNameHelper.getShortClassName((String)fqName);
            PersistenceMappings currentMappings = DatabaseSchemaImporter.getCurrentMappings(mappings, singleXmlPerEntity, choosenXmlFormat, psiDirectory, shortName, this.myFacet);
            PersistenceMappingsManipulator mappingsManipulator = (PersistenceMappingsManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)currentMappings, PersistenceMappingsManipulator.class);
            if (mappingsManipulator == null) {
                return;
            }
            PersistentEntity entity = mappingsManipulator.addEntity(psiDirectory, unit, shortName, (String)ejb.getAbstractSchemaName().getValue());
            entityMap.put((Object)ejb, (Object)entity);
            PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
            if (entityManipulator == null) continue;
            PropertyMemberType propertyMemberType = accessType = ejb.getCmpVersion().getValue() == CmpVersion.CmpVersion_2_X ? PropertyMemberType.GETTER : PropertyMemberType.FIELD;
            if (ejb.getPrimkeyField().getStringValue() != null) {
                pkFieldNames = Collections.singleton(ejb.getPrimkeyField().getStringValue());
            } else if (ejb.getPrimKeyClass().getValue() != null) {
                pkFieldNames = new HashSet<String>();
                PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
                for (PsiField psiField : pkClass.getAllFields()) {
                    if (!psiField.hasModifierProperty("public") || psiField.hasModifierProperty("static") || psiField.hasModifierProperty("private")) continue;
                    pkFieldNames.add(psiField.getName());
                }
                if (pkFieldNames.size() > 0) {
                    entityManipulator.setIdClass(this.getNewClassName(ejb.getPrimKeyClass().getStringValue(), "", ""));
                }
            } else {
                pkFieldNames = Collections.emptySet();
            }
            for (CmpField cmpField : ejb.getCmpFields()) {
                String fieldName = (String)cmpField.getFieldName().getValue();
                PsiMember member = cmpField.getPsiMember();
                Object fieldType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? ((PsiMethod)member).getReturnType() : PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)module.getProject()), (GlobalSearchScope)ProjectScope.getAllScope((Project)module.getProject())));
                ArrayList<PersistentAttribute> idAttributes = new ArrayList<PersistentAttribute>();
                if (pkFieldNames.contains(fieldName)) {
                    PersistentAttribute idAttr = entityManipulator.addIdAttribute(pkFieldNames.size() > 1, fieldName, fieldType, accessType, Collections.emptyList());
                    idAttributes.add(idAttr);
                } else {
                    entityManipulator.addAttribute(fieldName, fieldType, accessType, Collections.emptyList());
                }
                entityManipulator.ensureIdClassExists(idAttributes);
            }
            for (Query query : ejb.getQueries()) {
                String queryName = query.getQueryMethodName().getStringValue();
                entityManipulator.addNamedQuery(queryName, (String)query.getEjbQl().getValue());
            }
        }
        for (EntityBean ejb : this.myEjbFacet.getMergedRoot().getEnterpriseBeans().getEntities()) {
            if (ejb.getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
            PropertyMemberType accessType = ejb.getCmpVersion().getValue() == CmpVersion.CmpVersion_2_X ? PropertyMemberType.GETTER : PropertyMemberType.FIELD;
            PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)ejb, PersistentObjectManipulator.class);
            if (entityManipulator == null) continue;
            for (CmrField cmrField : ejb.getCmrFields()) {
                EntityBean targetEjb;
                PersistentEntity targetEntity;
                String fieldName = (String)cmrField.getCmrFieldName().getValue();
                if (fieldName == null || (targetEntity = (PersistentEntity)entityMap.get((Object)(targetEjb = cmrField.getOppositeEntity()))) == null) continue;
                CmrField cmrTargetField = cmrField.getOppositeField();
                String targetFieldName = (String)cmrTargetField.getCmrFieldName().getValue();
                Multiplicity multiplicity = (Multiplicity)cmrField.getMultiplicity().getValue();
                Multiplicity targetMultiplicity = (Multiplicity)cmrTargetField.getMultiplicity().getValue();
                RelationshipType type = RelationshipType.getRelationshipType((multiplicity == Multiplicity.MANY ? 1 : 0) != 0, (targetMultiplicity == Multiplicity.MANY ? 1 : 0) != 0);
                boolean inverse = !cmrField.isRelationshipSource() && targetFieldName != null;
                boolean cascadeRemove = Boolean.TRUE.equals(cmrField.getCascadeDelete().getValue());
                List cascadeVariants = cascadeRemove ? Arrays.asList("remove", "delete") : Collections.emptyList();
                entityManipulator.addRelationshipAttribute((PersistentEntityBase)targetEntity, type, JavaContainerType.COLLECTION, fieldName, targetFieldName, inverse, true, null, cascadeVariants, accessType);
            }
        }
    }
}

