/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalSegment;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public class MovingGuideRenderer {
    private static final String NID_MOVING_GUIDE = "movingGuide";
    private final Group guideGroup = new Group();
    private final Map<AbstractSegment, Line> chromeMap = new HashMap<AbstractSegment, Line>();
    private final Set<Line> reusableChromes = new HashSet<Line>();
    private final Paint chromeColor;
    private final Bounds scopeInScene;

    public MovingGuideRenderer(Paint chromeColor, Bounds scopeInScene) {
        this.chromeColor = chromeColor;
        this.scopeInScene = scopeInScene;
        this.guideGroup.setMouseTransparent(true);
    }

    public void setLines(List<? extends AbstractSegment> lines1, List<? extends AbstractSegment> lines2) {
        assert (lines1 != null);
        assert (lines2 != null);
        assert (this.guideGroup.getScene() != null);
        Set<AbstractSegment> currentLines = this.chromeMap.keySet();
        HashSet<AbstractSegment> newLines = new HashSet<AbstractSegment>();
        newLines.addAll(lines1);
        newLines.addAll(lines2);
        newLines.removeAll(currentLines);
        HashSet<AbstractSegment> obsoleteLines = new HashSet<AbstractSegment>();
        obsoleteLines.addAll(currentLines);
        obsoleteLines.removeAll(lines1);
        obsoleteLines.removeAll(lines2);
        for (AbstractSegment s : obsoleteLines) {
            Line chrome = this.chromeMap.get(s);
            assert (chrome != null);
            this.reusableChromes.add(chrome);
            this.chromeMap.remove(s);
            chrome.setVisible(false);
        }
        Bounds scope = this.guideGroup.sceneToLocal(this.scopeInScene, true);
        for (AbstractSegment s : newLines) {
            double endY;
            double endX;
            double startY;
            double startX;
            Line chrome;
            if (this.reusableChromes.isEmpty()) {
                chrome = new Line();
                chrome.setId(NID_MOVING_GUIDE);
                chrome.setStroke(this.chromeColor);
                this.guideGroup.getChildren().add((Object)chrome);
            } else {
                chrome = this.reusableChromes.iterator().next();
                this.reusableChromes.remove(chrome);
                chrome.setVisible(true);
            }
            Point2D p1 = this.guideGroup.sceneToLocal(s.getX1(), s.getY1(), true);
            Point2D p2 = this.guideGroup.sceneToLocal(s.getX2(), s.getY2(), true);
            if (s instanceof HorizontalSegment) {
                assert (MathUtils.equals(p1.getY(), p2.getY()));
                startX = scope.getMinX();
                startY = p1.getY();
                endX = scope.getMaxX();
                endY = p1.getY();
            } else {
                assert (s instanceof VerticalSegment);
                assert (MathUtils.equals(p1.getX(), p2.getX()));
                startX = p1.getX();
                startY = scope.getMinY();
                endX = p1.getX();
                endY = scope.getMaxY();
            }
            chrome.setStartX(startX);
            chrome.setStartY(startY);
            chrome.setEndX(endX);
            chrome.setEndY(endY);
            assert (!this.chromeMap.containsKey(s));
            this.chromeMap.put(s, chrome);
        }
    }

    public Group getGuideGroup() {
        return this.guideGroup;
    }
}

