/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PropertiesStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/properties/formatting/PropertiesStripTrailingSpacesFilterFactory", "createFilter"));
        }
        PsiBasedStripTrailingSpacesFilter psiBasedStripTrailingSpacesFilter = new PsiBasedStripTrailingSpacesFilter(document){

            protected void process(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/properties/formatting/PropertiesStripTrailingSpacesFilterFactory$1", "process"));
                }
                new PsiRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        ASTNode valueNode;
                        if (element instanceof PropertyImpl && (valueNode = ((PropertyImpl)element).getValueNode()) != null) {
                            this.disableRange(valueNode.getTextRange(), true);
                        }
                        super.visitElement(element);
                    }
                }.visitElement((PsiElement)psiFile);
            }
        };
        if (psiBasedStripTrailingSpacesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/formatting/PropertiesStripTrailingSpacesFilterFactory", "createFilter"));
        }
        return psiBasedStripTrailingSpacesFilter;
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/properties/formatting/PropertiesStripTrailingSpacesFilterFactory", "isApplicableTo"));
        }
        return language.is(StdLanguages.PROPERTIES);
    }
}

