/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.ide.actions.NewElementAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.uml.core.actions.UmlAddNoteAction;
import com.intellij.uml.core.actions.UmlLineToAction;
import java.util.List;

public class UmlNewAction
extends NewElementAction {
    public void actionPerformed(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder((AnActionEvent)e);
        List nodes = DiagramAction.getSelectedNodes((AnActionEvent)e);
        if (builder != null) {
            ListPopup popup = this.createPopup(e.getDataContext());
            if (nodes.size() == 1) {
                Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode((DiagramNode)nodes.get(0)), (Graph2DView)builder.getView());
            } else {
                Utils.showInGraphCenter((JBPopup)popup, (Graph2D)builder.getGraph());
            }
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled = false;
        DiagramBuilder builder = (DiagramBuilder)e.getData(DiagramDataKeys.BUILDER);
        if (builder != null && !builder.isPopupMode()) {
            ActionGroup group = this.getGroup(e.getDataContext());
            enabled = group.getChildren(e).length > 0;
        }
        e.getPresentation().setEnabled(enabled);
    }

    public ActionGroup getGroup(DataContext dataContext) {
        DiagramBuilder builder = (DiagramBuilder)DiagramDataKeys.BUILDER.getData(dataContext);
        if (builder != null) {
            DiagramEdgeCreationPolicy policy;
            AnAction[] elementActions;
            DiagramProvider provider = builder.getProvider();
            AnAction[] actions = provider.getCreateNewActions();
            DefaultActionGroup group = new DefaultActionGroup();
            if (actions != null && actions.length > 0) {
                group.addAll(actions);
            }
            if ((elementActions = provider.getCreateNewNodeElementActions()).length > 0) {
                if (group.getChildrenCount() > 0) {
                    group.addSeparator();
                }
                group.addAll(elementActions);
            }
            if ((policy = provider.getEdgeCreationPolicy()) != null) {
                if (group.getChildrenCount() > 0) {
                    group.addSeparator();
                }
                group.add((AnAction)new UmlLineToAction(policy.getLineToActionName(), policy.getLineToActionDescription()));
            }
            group.add((AnAction)new UmlAddNoteAction());
            if (group.getChildrenCount() > 0) {
                return group;
            }
        }
        return ActionGroup.EMPTY_GROUP;
    }
}

