/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewModuleDiagramAction
extends AnAction {
    protected NewModuleDiagramAction() {
        super("Module Dependencies Diagram", null, AllIcons.FileTypes.Diagram);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/project/actions/NewModuleDiagramAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        VirtualFile file = NewModuleDiagramAction.getFile(e);
        if (file != null) {
            FileEditor[] fileEditors;
            DiagramState state = new DiagramState(DiagramProvider.findByID((String)"MODULES"));
            state.setOriginalFQN("");
            state.saveTo(file, project);
            for (FileEditor editor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file, true)) {
                if (!(editor instanceof UmlFileEditorImpl)) continue;
                ((UmlFileEditorImpl)editor).getBuilder().getDataModel().setShowDependencies(true);
                break;
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/project/actions/NewModuleDiagramAction", "update"));
        }
        boolean ultimate = PlatformUtils.isIdeaUltimate();
        boolean visible = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()) != null;
        Project project = e.getProject();
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || view == null || view.getDirectories().length == 0) {
            visible = false;
        }
        e.getPresentation().setEnabledAndVisible(ultimate && visible);
    }

    @Nullable
    public static VirtualFile getFile(AnActionEvent e) {
        try {
            File file = FileUtil.createTempFile((String)"modules", (String)".uml", (boolean)true);
            return LocalFileSystem.getInstance().findFileByIoFile(file);
        }
        catch (IOException io) {
            return null;
        }
    }
}

